/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.common.world.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public abstract class TorchHelper {
    public static final float SHEAR = 0.401f;
    public static final float Y_SHIFT = 0.198f;
    public static final float XZ_SHIFT = 0.579f;

    public static boolean isLikeTorch(BlockState blockState) {
        return BlockUtil.match(blockState, Blocks.f_50081_, Blocks.f_50174_, Blocks.f_50139_, Blocks.f_50082_, Blocks.f_50123_, Blocks.f_50140_);
    }

    public static boolean isNotLikeTorch(BlockState blockState) {
        return !TorchHelper.isLikeTorch(blockState);
    }

    public static boolean isOldWall(BlockState blockState) {
        return (Boolean)CandyTweak.OLD_TORCH_MODEL.get() != false && blockState.m_60713_(Blocks.f_50082_);
    }

    public static boolean isOldSoulWall(BlockState blockState) {
        return (Boolean)CandyTweak.OLD_SOUL_TORCH_MODEL.get() != false && blockState.m_60713_(Blocks.f_50140_);
    }

    public static boolean isOldRedstoneWall(BlockState blockState) {
        return (Boolean)CandyTweak.OLD_REDSTONE_TORCH_MODEL.get() != false && blockState.m_60713_(Blocks.f_50123_);
    }

    public static boolean isSheared(BlockState blockState) {
        return TorchHelper.isOldWall(blockState) || TorchHelper.isOldSoulWall(blockState) || TorchHelper.isOldRedstoneWall(blockState);
    }

    public static BakedModel getModel(BlockState blockState) {
        BlockState defaultTorch = Blocks.f_50081_.m_49966_();
        if (TorchHelper.isOldRedstoneWall(blockState)) {
            defaultTorch = Blocks.f_50174_.m_152465_(blockState);
        } else if (TorchHelper.isOldSoulWall(blockState)) {
            defaultTorch = Blocks.f_50139_.m_152465_(blockState);
        }
        return Minecraft.m_91087_().m_91289_().m_110910_(defaultTorch);
    }

    public static boolean isBright(BlockState blockState) {
        if (BlockUtil.match(blockState, Blocks.f_50174_, Blocks.f_50123_)) {
            return (Boolean)CandyTweak.OLD_TORCH_BRIGHTNESS.get() != false && (Boolean)blockState.m_61143_((Property)RedstoneTorchBlock.f_55674_) != false;
        }
        return (Boolean)CandyTweak.OLD_TORCH_BRIGHTNESS.get();
    }

    public static void applyShear(PoseStack poseStack, BlockState blockState) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Direction direction = (Direction)blockState.m_61143_((Property)WallTorchBlock.f_58119_);
        switch (direction) {
            case NORTH: {
                matrix.m12(-0.401f);
                poseStack.m_252880_(0.0f, 0.198f, 0.579f);
                break;
            }
            case SOUTH: {
                matrix.m12(0.401f);
                poseStack.m_252880_(0.0f, 0.198f, -0.579f);
                break;
            }
            case EAST: {
                matrix.m10(0.401f);
                poseStack.m_252880_(-0.579f, 0.198f, 0.0f);
                break;
            }
            case WEST: {
                matrix.m10(-0.401f);
                poseStack.m_252880_(0.579f, 0.198f, 0.0f);
            }
        }
    }

    public static void writeVertices(PoseStack poseStack, BlockAndTintGetter blockAndTintGetter, VertexConsumer vertexConsumer, BakedModel model, BlockState blockState, BlockPos blockPos, RandomSource random) {
        int brightness;
        int blockLight = blockAndTintGetter.m_45517_(LightLayer.BLOCK, blockPos);
        int skyLight = blockAndTintGetter.m_45517_(LightLayer.SKY, blockPos);
        int n = brightness = TorchHelper.isBright(blockState) ? 0xF000F0 : LightTexture.m_109885_((int)blockLight, (int)skyLight);
        if (!TorchHelper.isSheared(blockState)) {
            for (BakedQuad quad : model.m_213637_(blockState, null, random)) {
                vertexConsumer.m_85987_(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, brightness, OverlayTexture.f_118083_);
            }
            return;
        }
        boolean isBottomDisabled = (Boolean)CandyTweak.OLD_TORCH_BOTTOM.get();
        poseStack.m_85836_();
        TorchHelper.applyShear(poseStack, blockState);
        for (BakedQuad quad : TorchHelper.getModel(blockState).m_213637_(blockState, null, random)) {
            if (isBottomDisabled && quad.m_111306_() == Direction.DOWN) continue;
            vertexConsumer.m_85987_(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, brightness, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
    }
}

