/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.debug;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FastColor;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;

class DebugChartRenderer {
    final int width;
    final int height;
    final GuiGraphics graphics;
    final FrameTimer frameTimer;

    DebugChartRenderer(GuiGraphics graphics, FrameTimer frameTimer) {
        this.width = Math.min(graphics.m_280182_() / 2, 240);
        this.height = 76;
        this.graphics = graphics;
        this.frameTimer = frameTimer;
    }

    public void render() {
        long minVal = Integer.MIN_VALUE;
        long maxVal = Integer.MAX_VALUE;
        long[] logs = this.frameTimer.m_13764_();
        int maxSize = Math.max(0, logs.length - this.width);
        int numOfValues = logs.length - maxSize;
        int logStart = this.frameTimer.m_13754_();
        int wrapIndex = this.frameTimer.m_13762_(Math.max(0, logStart + maxSize - 1));
        this.graphics.m_280168_().m_85836_();
        this.graphics.m_280168_().m_252880_(0.0f, (float)this.graphics.m_280206_() - (float)this.height / 2.0f, 0.0f);
        this.graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        this.graphics.m_285944_(RenderType.m_286086_(), 0, 0, this.width, this.height, -1876951040);
        this.graphics.m_285944_(RenderType.m_286086_(), 0, 36, this.width, this.height, -1879048192);
        for (int i = 0; i < numOfValues; ++i) {
            long value = logs[this.frameTimer.m_13762_(wrapIndex + i)];
            minVal = Math.min(minVal, value);
            maxVal = Math.max(maxVal, value);
            int minY = this.getSampleHeight(value);
            int color = this.getSampleColor(value);
            this.graphics.m_285944_(RenderType.m_286086_(), i, this.height - minY, i + 1, this.height, color);
        }
        int fpsLimit = (Integer)Minecraft.m_91087_().f_91066_.m_232035_().m_231551_();
        if (fpsLimit > 0 && fpsLimit <= 250) {
            this.graphics.m_285844_(RenderType.m_286086_(), 0, this.width - 1, this.height - this.getSampleHeight(1.0E9 / (double)fpsLimit) - 1, -65536);
        }
        this.graphics.m_280168_().m_85849_();
    }

    private int getSampleHeight(double value) {
        return (int)Math.round(this.toMillis(value) * 60.0 / 33.333333333333336);
    }

    private int getSampleColor(long value) {
        long clamp = (long)Mth.m_14008_((double)this.toMillis(value), (double)0.0, (double)56.0);
        int min = FastColor.ARGB32.m_269105_((float)((float)((double)clamp / 28.0)), (int)-16711936, (int)-256);
        int max = FastColor.ARGB32.m_269105_((float)((float)(((double)clamp - 28.0) / 28.0)), (int)-256, (int)-65536);
        return (double)clamp < 28.0 ? min : max;
    }

    private double toMillis(double value) {
        return value / 1000000.0;
    }
}

