/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.debug;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import mod.adrenix.nostalgic.mixin.access.DebugScreenOverlayAccess;
import mod.adrenix.nostalgic.mixin.access.LevelRendererAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.Generic;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

class DebugInfoRenderer {
    final LevelRenderer levelRenderer;
    final ClientLevel level;
    final Minecraft minecraft;
    final GuiGraphics graphics;
    final HitResult blockHit;
    final HitResult liquidHit;
    final Entity player;
    final BlockPos playerPos;
    final Function<Map.Entry<Property<?>, Comparable<?>>, String> getPropertyValue;
    final Function<Holder<Biome>, String> printBiome;
    final ArrayList<String> left;
    final ArrayList<String> right;
    final boolean isReducedInfo;

    DebugInfoRenderer(DebugScreenOverlay overlay, GuiGraphics graphics) {
        this.graphics = graphics;
        this.minecraft = Minecraft.m_91087_();
        this.player = this.minecraft.f_91075_;
        this.level = this.minecraft.f_91073_;
        this.levelRenderer = this.minecraft.f_91060_;
        assert (this.level != null) : "No level was present when rendering debug information";
        assert (this.player != null) : "No player was present when rendering debug information";
        this.playerPos = this.player.m_20183_();
        this.isReducedInfo = this.minecraft.m_91299_();
        this.blockHit = ((DebugScreenOverlayAccess)overlay).nt$getBlockHitResult();
        this.liquidHit = ((DebugScreenOverlayAccess)overlay).nt$getLiquidHitResult();
        this.getPropertyValue = ((DebugScreenOverlayAccess)overlay)::nt$getPropertyValueString;
        this.printBiome = DebugScreenOverlayAccess::nt$printBiome;
        this.left = new ArrayList();
        this.right = new ArrayList();
    }

    public void render() {
        this.setGameInformation();
        if (!this.isReducedInfo) {
            this.setExtraGameInformation();
        }
        for (int i = 0; i < this.left.size(); ++i) {
            String text = this.left.get(i);
            if (Strings.isNullOrEmpty((String)text)) continue;
            this.drawBackground(text, i, true);
            this.drawText(text, 2, 2 + GuiUtil.textHeight() * i, true);
        }
        int width = this.minecraft.m_91268_().m_85445_();
        for (int i = 0; i < this.right.size(); ++i) {
            String text = this.right.get(i);
            int x = width - 2 - GuiUtil.font().m_92895_(text);
            int y = 2 + GuiUtil.textHeight() * i;
            this.drawBackground(text, i, false);
            this.drawText(text, x, y, false);
        }
    }

    void drawText(String text, int x, int y, boolean leftSide) {
        boolean dropShadow;
        int color;
        if (leftSide) {
            color = (Boolean)CandyTweak.SHOW_DEBUG_LEFT_TEXT_COLOR.get() != false ? HexUtil.parseInt((String)CandyTweak.DEBUG_LEFT_TEXT_COLOR.get()) : Color.WHITE.get();
            dropShadow = (Boolean)CandyTweak.SHOW_DEBUG_LEFT_TEXT_SHADOW.get();
        } else {
            color = (Boolean)CandyTweak.SHOW_DEBUG_RIGHT_TEXT_COLOR.get() != false ? HexUtil.parseInt((String)CandyTweak.DEBUG_RIGHT_TEXT_COLOR.get()) : Color.NOSTALGIC_GRAY.get();
            dropShadow = (Boolean)CandyTweak.SHOW_DEBUG_RIGHT_TEXT_SHADOW.get();
        }
        this.graphics.m_280056_(GuiUtil.font(), text, x, y, color, dropShadow);
    }

    void drawBackground(String text, int index, boolean leftSide) {
        boolean isRightOff;
        boolean isLeftOff = leftSide && (Boolean)CandyTweak.SHOW_DEBUG_LEFT_BACKGROUND.get() == false;
        boolean bl = isRightOff = !leftSide && (Boolean)CandyTweak.SHOW_DEBUG_RIGHT_BACKGROUND.get() == false;
        if (isLeftOff || isRightOff) {
            return;
        }
        String hex = leftSide ? (String)CandyTweak.DEBUG_LEFT_BACKGROUND_COLOR.get() : (String)CandyTweak.DEBUG_RIGHT_BACKGROUND_COLOR.get();
        int color = HexUtil.parseInt(hex);
        int scaledWidth = GuiUtil.getGuiWidth();
        int fontWidth = GuiUtil.font().m_92895_(text);
        int fontHeight = GuiUtil.textHeight();
        int minX = leftSide ? 1 : scaledWidth - 2 - fontWidth - 1;
        int maxX = leftSide ? 2 + fontWidth + 1 : scaledWidth - 2 - fontWidth + fontWidth + 1;
        int minY = 2 + fontHeight * index - 1;
        int maxY = 2 + fontHeight * index + fontHeight - 1;
        this.graphics.m_280509_(minX, minY, maxX, maxY, color);
    }

    void setGameInformation() {
        String gpu;
        String usage;
        int width = this.minecraft.m_91268_().m_85445_();
        int chunkUpdates = this.levelRenderer.m_173015_().m_173713_();
        int renderedEntities = ((LevelRendererAccess)this.levelRenderer).nt$getRenderedEntities();
        int culledEntities = ((LevelRendererAccess)this.levelRenderer).nt$getCulledEntities();
        String overlay = CandyTweak.OLD_OVERLAY_TEXT.parse(GameUtil.getVersion());
        Object title = overlay.isEmpty() ? "Minecraft " + GameUtil.getVersion() : overlay;
        String fps = String.format(" (%s fps, %s chunk updates)", this.minecraft.m_260875_(), chunkUpdates);
        String sections = String.format("C: %d/%d. F: 0, O: 0, E: 0", this.levelRenderer.m_109821_(), (long)this.levelRenderer.m_173016_());
        String entities = String.format("E: %s/%s. B: %s, I: 0", renderedEntities, this.level.m_104813_(), culledEntities);
        String particles = String.format("P: %s. T: All: %s", this.minecraft.f_91061_.m_107403_(), this.level.m_104813_());
        String overflow = String.format(" (%s fps)", this.minecraft.m_260875_());
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        String memory = String.format("Used memory: %2d%% (%03dMB) of %03dMB", used * 100L / max, MathUtil.bytesToMegabytes(used), MathUtil.bytesToMegabytes(max));
        String allocated = String.format("Allocated memory: %2d%% (%03dMB)", total * 100L / max, MathUtil.bytesToMegabytes(total));
        if (GuiUtil.font().m_92895_((String)title + fps) + 2 > width - 2 - GuiUtil.font().m_92895_(memory)) {
            fps = overflow;
        }
        this.left.add((String)title + fps);
        this.left.add(sections);
        this.left.add(entities);
        this.left.add(particles);
        this.right.add(memory);
        this.right.add(allocated);
        if (((Boolean)CandyTweak.SHOW_DEBUG_GPU_USAGE.get()).booleanValue() && !(usage = TextUtil.extract(gpu = TextUtil.extract(this.minecraft.f_90977_, "GPU:.+"), "\\d+")).isEmpty()) {
            this.right.add("GPU usage: " + TextUtil.getPercentColorHigh(Integer.parseInt(usage)) + "%");
        }
        if (CandyTweak.OLD_DEBUG.get() == Generic.BETA) {
            this.left.add(String.format("ChunkCache: %d", this.level.m_7726_().m_8482_()));
            if (!this.isReducedInfo) {
                this.left.add("");
                this.left.add(String.format("X: %f", this.player.m_20185_()));
                this.left.add(String.format("Y: %f", this.player.m_20186_()));
                this.left.add(String.format("Z: %f", this.player.m_20189_()));
            }
        }
    }

    void setExtraGameInformation() {
        BlockState targetState;
        BlockPos targetPos;
        boolean isValidHeight;
        this.left.add("");
        if (((Boolean)CandyTweak.SHOW_DEBUG_FACING_DATA.get()).booleanValue()) {
            Direction direction = this.player.m_6350_();
            String facing = switch (direction) {
                case Direction.NORTH -> "Towards negative Z";
                case Direction.SOUTH -> "Towards positive Z";
                case Direction.WEST -> "Towards negative X";
                case Direction.EAST -> "Towards positive X";
                default -> "Invalid";
            };
            this.left.add(String.format("Facing: %s (%s) (%.1f / %.1f)", direction, facing, Float.valueOf(Mth.m_14177_((float)this.player.m_146908_())), Float.valueOf(Mth.m_14177_((float)this.player.m_146909_()))));
        }
        if (((Boolean)CandyTweak.SHOW_DEBUG_LIGHT_DATA.get()).booleanValue()) {
            int skyLight = this.level.m_45517_(LightLayer.SKY, this.playerPos);
            int blockLight = this.level.m_45517_(LightLayer.BLOCK, this.playerPos);
            int brightness = this.level.m_7726_().m_7827_().m_75831_(this.playerPos, 0);
            this.left.add(String.format("Light: %d (%d sky, %d block)", brightness, skyLight, blockLight));
        }
        Entity targetEntity = this.minecraft.f_91076_;
        boolean isTargeted = (Boolean)CandyTweak.SHOW_DEBUG_TARGET_DATA.get();
        boolean bl = isValidHeight = this.playerPos.m_123342_() >= this.level.m_141937_() && this.playerPos.m_123342_() < this.level.m_151558_();
        if (((Boolean)CandyTweak.SHOW_DEBUG_BIOME_DATA.get()).booleanValue() && isValidHeight) {
            this.left.add(String.format("Biome: %s", this.printBiome.apply((Holder<Biome>)this.level.m_204166_(this.playerPos))));
        }
        if (isTargeted && this.blockHit.m_6662_() == HitResult.Type.BLOCK) {
            targetPos = ((BlockHitResult)this.blockHit).m_82425_();
            targetState = this.level.m_8055_(targetPos);
            this.right.add("");
            this.right.add(String.format(ChatFormatting.UNDERLINE + "Targeted Block: %s, %s, %s", targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_()));
            this.right.add(String.valueOf(BuiltInRegistries.f_256975_.m_7981_((Object)targetState.m_60734_())));
            for (Map.Entry entry : targetState.m_61148_().entrySet()) {
                this.right.add(this.getPropertyValue.apply(entry));
            }
            targetState.m_204343_().map(tagKey -> "#" + tagKey.f_203868_()).forEach(this.right::add);
        }
        if (isTargeted && this.liquidHit.m_6662_() == HitResult.Type.BLOCK) {
            targetPos = ((BlockHitResult)this.liquidHit).m_82425_();
            targetState = this.level.m_6425_(targetPos);
            this.right.add("");
            this.right.add(String.format(ChatFormatting.UNDERLINE + "Targeted Fluid: %s, %s, %s", targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_()));
            this.right.add(String.valueOf(BuiltInRegistries.f_257020_.m_7981_((Object)targetState.m_76152_())));
            for (Map.Entry entry : targetState.m_61148_().entrySet()) {
                this.right.add(this.getPropertyValue.apply(entry));
            }
            targetState.m_205075_().map(tagKey -> "#" + tagKey.f_203868_()).forEach(this.right::add);
        }
        if (isTargeted && targetEntity != null) {
            this.right.add("");
            this.right.add(ChatFormatting.UNDERLINE + "Targeted Entity:");
            this.right.add(String.valueOf(BuiltInRegistries.f_256780_.m_7981_((Object)targetEntity.m_6095_())));
        }
    }
}

