/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.level;

import mod.adrenix.nostalgic.util.common.data.NumberHolder;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;

public abstract class ClientLevelHelper {
    private static final NumberHolder<Float> BIOME_TEMPERATURE = NumberHolder.create(Float.valueOf(Float.NaN));

    public static float getBiomeTemperature() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        if (player == null) {
            return 0.0f;
        }
        float temperature = ((Biome)player.m_9236_().m_204166_(camera.m_90588_()).m_203334_()).m_47554_();
        if (Float.isNaN(((Float)BIOME_TEMPERATURE.get()).floatValue())) {
            BIOME_TEMPERATURE.set(Float.valueOf(temperature));
        } else {
            BIOME_TEMPERATURE.set(Float.valueOf(MathUtil.moveTowards(((Float)BIOME_TEMPERATURE.get()).floatValue(), temperature, 1.0E-5f)));
        }
        return ((Float)BIOME_TEMPERATURE.get()).floatValue();
    }

    public static float[] getStandardEnvironmentInfluence() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        float partialTick = minecraft.m_91296_();
        float timeOfDay = level.m_46942_(partialTick);
        float boundedTime = Mth.m_14036_((float)(Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float rain = 1.0f - level.m_46722_(partialTick) + 0.4f;
        float thunder = 1.0f - level.m_46661_(partialTick) + 0.2f;
        float weather = Mth.m_14036_((float)Math.min(rain, thunder), (float)0.0f, (float)1.0f);
        float r = boundedTime * weather;
        float g = boundedTime * weather;
        float b = boundedTime * weather;
        return new float[]{r, g, b};
    }

    public static int getSkyLight(Entity entity) {
        return entity.m_9236_().m_45517_(LightLayer.SKY, entity.m_20183_().m_7494_());
    }

    public static int getMaxLight(Entity entity) {
        return Mth.m_14045_((int)entity.m_9236_().m_46803_(entity.m_20183_().m_7494_()), (int)0, (int)15);
    }
}

