/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.level;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.util.function.BiFunction;
import mod.adrenix.nostalgic.helper.candy.level.ClientLevelHelper;
import mod.adrenix.nostalgic.helper.candy.level.fog.VoidFogRenderer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.Generic;
import mod.adrenix.nostalgic.tweak.enums.SkyColor;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.Holder;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public abstract class SkyHelper {
    public static final FlagHolder STARS_RUNNABLE_SAVED = FlagHolder.off();
    public static final FlagHolder BLUE_RUNNABLE_SAVED = FlagHolder.off();
    public static final Holder<Matrix4f> MODEL_VIEW_MATRIX = Holder.create(new Matrix4f());
    public static final Holder<Matrix4f> PROJECTION_MATRIX = Holder.create(new Matrix4f());
    public static final NullableHolder<VertexBuffer> BLUE_VOID_BUFFER = NullableHolder.empty();

    public static void createBlueVoid(BiFunction<BufferBuilder, Float, BufferBuilder.RenderedBuffer> skyDiscBuilder) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        float height = switch ((Generic)CandyTweak.OLD_BLUE_VOID.get()) {
            default -> throw new IncompatibleClassChangeError();
            case Generic.ALPHA -> -32.0f;
            case Generic.BETA, Generic.MODERN -> -48.0f;
        };
        BufferBuilder.RenderedBuffer renderedBuffer = skyDiscBuilder.apply(builder, Float.valueOf(height));
        if (renderedBuffer != null) {
            BLUE_VOID_BUFFER.ifPresent(VertexBuffer::close);
            BLUE_VOID_BUFFER.set(new VertexBuffer(VertexBuffer.Usage.STATIC));
            BLUE_VOID_BUFFER.ifPresent(VertexBuffer::m_85921_);
            BLUE_VOID_BUFFER.ifPresent(buffer -> buffer.m_231221_(renderedBuffer));
            VertexBuffer.m_85931_();
        }
    }

    private static float[] getBlueEnvironmentInfluence() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        float partialTicks = minecraft.m_91296_();
        float timeOfDay = level.m_46942_(partialTicks);
        float boundedTime = Mth.m_14036_((float)(Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float voidRed = (float)((double)0.3f * (double)(boundedTime * 0.05f + 0.95f));
        float voidGreen = (float)((double)0.24f * (double)(boundedTime * 0.05f + 0.95f));
        float voidBlue = (float)((double)0.85f * (double)(boundedTime * 0.85f + 0.15f));
        float rainLevel = level.m_46722_(partialTicks);
        float thunderLevel = level.m_46661_(partialTicks);
        if (rainLevel > 0.0f) {
            float redGreenShift = 1.0f - rainLevel * 0.5f;
            float blueShift = 1.0f - rainLevel * 0.4f;
            voidRed *= redGreenShift;
            voidGreen *= redGreenShift;
            voidBlue *= blueShift;
        }
        if (thunderLevel > 0.0f) {
            float shift = 1.0f - thunderLevel * 0.5f;
            voidRed *= shift;
            voidGreen *= shift;
            voidBlue *= shift;
        }
        return new float[]{voidRed, voidGreen, voidBlue};
    }

    public static void setBlueColor() {
        boolean isCustom = (Boolean)CandyTweak.CUSTOM_VOID_SKY.get();
        float[] ENV_RGB = isCustom ? ClientLevelHelper.getStandardEnvironmentInfluence() : SkyHelper.getBlueEnvironmentInfluence();
        float r = ENV_RGB[0];
        float g = ENV_RGB[1];
        float b = ENV_RGB[2];
        float OLD_RED = 0.13f;
        float OLD_GREEN = 0.17f;
        float OLD_BLUE = 0.7f;
        float[] CUSTOM_RGB = HexUtil.parseFloatRGBA((String)CandyTweak.CUSTOM_VOID_SKY_COLOR.get());
        r = Mth.m_14036_((float)r, (float)0.08f, (float)1.0f) * (isCustom ? CUSTOM_RGB[0] : 0.13f);
        g = Mth.m_14036_((float)g, (float)0.08f, (float)1.0f) * (isCustom ? CUSTOM_RGB[1] : 0.17f);
        b = Mth.m_14036_((float)b, (float)0.08f, (float)1.0f) * (isCustom ? CUSTOM_RGB[2] : 0.7f);
        VoidFogRenderer.setVoidRGB(r, g, b);
        if (VoidFogRenderer.isRendering()) {
            float[] VOID_RGB = VoidFogRenderer.getVoidRGB();
            r = VOID_RGB[0];
            g = VOID_RGB[1];
            b = VOID_RGB[2];
        }
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
    }

    private static int getColorFromBiome() {
        float temp = ClientLevelHelper.getBiomeTemperature() / 2.0f;
        return Color.getHSBColor(0.653f - temp * 0.05f, 0.415f + temp * 0.1f, 1.0f).get();
    }

    public static int getOldColor(int color) {
        if (GameUtil.isInOverworld()) {
            if (GameUtil.getRenderDistance() <= 4) {
                return HexUtil.parseInt(RenderSystem.getShaderFogColor());
            }
            SkyColor skyColor = (SkyColor)CandyTweak.UNIVERSAL_SKY_COLOR.get();
            if (((Boolean)CandyTweak.CUSTOM_OVERWORLD_SKY.get()).booleanValue()) {
                return HexUtil.parseInt((String)CandyTweak.CUSTOM_OVERWORLD_SKY_COLOR.get());
            }
            if (((Boolean)CandyTweak.OLD_DYNAMIC_SKY_COLOR.get()).booleanValue()) {
                return SkyHelper.getColorFromBiome();
            }
            return switch (skyColor) {
                default -> throw new IncompatibleClassChangeError();
                case SkyColor.DISABLED -> color;
                case SkyColor.CLASSIC -> 10276351;
                case SkyColor.INF_DEV -> 13033215;
                case SkyColor.ALPHA -> 9158143;
                case SkyColor.BETA -> 9937919;
            };
        }
        if (GameUtil.isInNether() && ((Boolean)CandyTweak.OLD_NETHER_SKY.get()).booleanValue()) {
            return 2163973;
        }
        return color;
    }
}

