/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.level.fog;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.helper.candy.level.ClientLevelHelper;
import mod.adrenix.nostalgic.helper.candy.level.fog.OverworldFogRenderer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.CameraUtil;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.timer.LerpTimer;
import mod.adrenix.nostalgic.util.common.world.BlockUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public abstract class VoidFogRenderer {
    private static final ArrayList<LerpTimer> LERP_TIMERS = new ArrayList();
    private static final LerpTimer CELESTIAL_TRANSPARENCY = VoidFogRenderer.makeTimer();
    private static final LerpTimer CLOUDS_TRANSPARENCY = VoidFogRenderer.makeTimer();
    private static final LerpTimer STARS_TRANSPARENCY = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_START = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_END = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_RED = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_GREEN = VoidFogRenderer.makeTimer();
    private static final LerpTimer FOG_BLUE = VoidFogRenderer.makeTimer();
    private static final LerpTimer VOID_RED = VoidFogRenderer.makeTimer();
    private static final LerpTimer VOID_GREEN = VoidFogRenderer.makeTimer();
    private static final LerpTimer VOID_BLUE = VoidFogRenderer.makeTimer();
    private static final LerpTimer SKY_RED = VoidFogRenderer.makeTimer();
    private static final LerpTimer SKY_GREEN = VoidFogRenderer.makeTimer();
    private static final LerpTimer SKY_BLUE = VoidFogRenderer.makeTimer();

    private static LerpTimer makeTimer() {
        LerpTimer timer = LerpTimer.create(2L, TimeUnit.SECONDS);
        LERP_TIMERS.add(timer);
        return timer;
    }

    public static void reset() {
        LERP_TIMERS.forEach(LerpTimer::clear);
    }

    private static void setTarget(LerpTimer timer, float target) {
        if (timer.isFinished() && VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            timer.stopAndSetTarget(Float.valueOf(target));
        } else {
            timer.setTarget(Float.valueOf(target));
        }
    }

    public static void setStarsTransparency(float alpha) {
        VoidFogRenderer.setTarget(STARS_TRANSPARENCY, Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f));
    }

    public static void setSkyRed(float red) {
        if (VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            VoidFogRenderer.setTarget(SKY_RED, Mth.m_14036_((float)red, (float)0.0f, (float)1.0f));
        }
    }

    public static void setSkyGreen(float green) {
        if (VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            VoidFogRenderer.setTarget(SKY_GREEN, Mth.m_14036_((float)green, (float)0.0f, (float)1.0f));
        }
    }

    public static void setSkyBlue(float blue) {
        if (VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            VoidFogRenderer.setTarget(SKY_BLUE, Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f));
        }
    }

    public static float getSkyRed() {
        return SKY_RED.lerpFloat();
    }

    public static float getSkyGreen() {
        return SKY_GREEN.lerpFloat();
    }

    public static float getSkyBlue() {
        return SKY_BLUE.lerpFloat();
    }

    public static void setVoidRGB(float red, float green, float blue) {
        if (!VoidFogRenderer.isGameOverride(CameraUtil.get())) {
            return;
        }
        VoidFogRenderer.setTarget(VOID_RED, Mth.m_14036_((float)red, (float)0.0f, (float)1.0f));
        VoidFogRenderer.setTarget(VOID_GREEN, Mth.m_14036_((float)green, (float)0.0f, (float)1.0f));
        VoidFogRenderer.setTarget(VOID_BLUE, Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f));
    }

    public static float[] getVoidRGB() {
        return new float[]{VOID_RED.lerpFloat(), VOID_GREEN.lerpFloat(), VOID_BLUE.lerpFloat()};
    }

    public static float getStarsTransparency() {
        return STARS_TRANSPARENCY.lerpFloat();
    }

    public static boolean isRendering() {
        return (Boolean)CandyTweak.RENDER_VOID_FOG.get();
    }

    private static boolean isDisabled(Camera camera) {
        boolean isNotSurvival = GameUtil.isNotSurvivalMode();
        boolean isHeightOutOfBounds = (double)((Integer)CandyTweak.VOID_FOG_START.get()).intValue() < camera.m_90592_().m_20186_() + 0.5;
        boolean isCreativeOverride = (Boolean)CandyTweak.CREATIVE_VOID_FOG.get() == false && isNotSurvival;
        boolean isVoidFogDisabled = (Boolean)CandyTweak.RENDER_VOID_FOG.get() == false;
        return isVoidFogDisabled || isHeightOutOfBounds || isCreativeOverride || VoidFogRenderer.isAboveHorizon();
    }

    public static boolean isGameOverride(Camera camera) {
        return VoidFogRenderer.isDisabled(camera) || CameraUtil.canSeeSky(camera) || CameraUtil.isInFluid(camera);
    }

    public static void setCelestialTransparency() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float partialTick = Minecraft.m_91087_().m_91296_();
        if (level == null) {
            return;
        }
        float[] rgb = RenderSystem.getShaderColor();
        float alpha = Math.min(1.0f - level.m_46722_(partialTick), CELESTIAL_TRANSPARENCY.lerpFloat());
        if (VoidFogRenderer.isRendering()) {
            RenderSystem.setShaderColor((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)alpha);
        }
    }

    public static void setCloudTransparency() {
        float[] rgb = RenderSystem.getShaderColor();
        float alpha = CLOUDS_TRANSPARENCY.lerpFloat();
        if (VoidFogRenderer.isRendering()) {
            RenderSystem.setShaderColor((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)alpha);
        }
    }

    private static boolean isAboveHorizon() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float partialTick = Minecraft.m_91087_().m_91296_();
        if (player == null || level == null) {
            return true;
        }
        return !(player.m_20299_((float)partialTick).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level) < 0.0);
    }

    private static int getMinBuildHeight(Entity entity) {
        return entity.m_9236_().m_141937_();
    }

    private static double getAbsoluteY(Entity entity) {
        return entity.m_20186_() - (double)VoidFogRenderer.getMinBuildHeight(entity);
    }

    private static float getFogStart(Camera camera, float distance) {
        return CameraUtil.isFoggy(camera) ? distance * 0.05f : distance * Math.max(0.0f, 0.55f * (1.0f - (distance - 5.0f) / 127.0f));
    }

    private static float getFogEnd(Camera camera, float distance) {
        return CameraUtil.isFoggy(camera) ? Math.min(distance, 192.0f) / 2.0f : distance;
    }

    private static int getMaxLight(Entity entity) {
        int light = (Boolean)CandyTweak.LIGHT_REMOVES_VOID_FOG.get() != false ? entity.m_9236_().m_46803_(entity.m_20183_()) : ClientLevelHelper.getSkyLight(entity);
        int encroachment = (int)((1.0f - (float)((Integer)CandyTweak.VOID_FOG_ENCROACH.get()).intValue() / 100.0f) * 15.0f);
        return Mth.m_14045_((int)(light + encroachment), (int)0, (int)15);
    }

    private static float getDarknessValue(Camera camera) {
        int fogStart = (Integer)CandyTweak.VOID_FOG_START.get();
        int skyLight = ClientLevelHelper.getSkyLight(camera.m_90592_());
        int maxHeight = fogStart - VoidFogRenderer.getMinBuildHeight(camera.m_90592_());
        float heightShift = (float)VoidFogRenderer.getAbsoluteY(camera.m_90592_()) / (float)maxHeight;
        return Math.max((float)Math.pow(Math.max(heightShift, (float)skyLight / 15.0f), 4.0), 0.05f);
    }

    private static float getDistance(Entity entity) {
        float renderDistance = Minecraft.m_91087_().f_91063_.m_109152_();
        double fogStart = ((Integer)CandyTweak.VOID_FOG_START.get()).intValue();
        double fogDistance = (double)VoidFogRenderer.getMaxLight(entity) / 16.0 + VoidFogRenderer.getAbsoluteY(entity) / (fogStart == 0.0 ? 1.0 : fogStart);
        return fogDistance >= 1.0 ? renderDistance : (float)Mth.m_14008_((double)(100.0 * Math.pow(Math.max(fogDistance, 0.0), 2.0)), (double)5.0, (double)renderDistance);
    }

    private static float getDistanceDelta(Entity entity) {
        return Math.max(1.0f, Math.min(1.0f, 1.0f - ((float)VoidFogRenderer.getAbsoluteY(entity) - (float)((Integer)CandyTweak.VOID_FOG_START.get()).intValue() - 15.0f) / 15.0f));
    }

    public static void addParticles(RandomSource randomSource) {
        boolean isDisabled;
        Entity entity = Minecraft.m_91087_().m_91288_();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        boolean isFogDisabled = (Boolean)CandyTweak.RENDER_VOID_FOG.get() == false || VoidFogRenderer.isAboveHorizon();
        boolean isCreativeDisabled = (Boolean)CandyTweak.CREATIVE_VOID_PARTICLES.get() == false && GameUtil.isCreativeMode();
        boolean bl = isDisabled = isFogDisabled || isCreativeDisabled;
        if (isDisabled || entity == null || level == null) {
            return;
        }
        BlockPos playerPos = entity.m_20183_();
        int radius = (Integer)CandyTweak.VOID_PARTICLE_RADIUS.get();
        int particleStart = (Integer)CandyTweak.VOID_PARTICLE_START.get();
        float density = (float)((Integer)CandyTweak.VOID_PARTICLE_DENSITY.get()).intValue() / 100.0f;
        if (GameUtil.isInOverworld() && Math.random() <= (double)density && entity.m_20186_() <= (double)particleStart) {
            BlockPos randX = BlockUtil.getRandom(randomSource, radius);
            BlockPos randY = BlockUtil.getRandom(randomSource, radius);
            BlockPos randPos = randX.m_121996_((Vec3i)randY).m_121955_((Vec3i)playerPos);
            BlockState blockState = level.m_8055_(randPos);
            FluidState fluidState = level.m_6425_(randPos);
            if (blockState.m_60795_() && fluidState.m_76178_() && randPos.m_123342_() <= particleStart && randomSource.m_188503_(8) <= particleStart - level.m_141937_()) {
                double px = (float)randPos.m_123341_() + randomSource.m_188501_();
                double py = (float)randPos.m_123342_() + randomSource.m_188501_();
                double pz = (float)randPos.m_123343_() + randomSource.m_188501_();
                boolean nearBedrock = BlockUtil.isNearBedrock(randPos, (Level)level);
                double ySpeed = nearBedrock ? (double)randomSource.m_188501_() : 0.0;
                SimpleParticleType particle = nearBedrock ? ParticleTypes.f_123783_ : ParticleTypes.f_123757_;
                level.m_7106_((ParticleOptions)particle, px, py, pz, 0.0, ySpeed, 0.0);
            }
        }
    }

    private static void lerpColor(float darkness, Color color, LerpTimer red, LerpTimer green, LerpTimer blue) {
        float saturation = Math.max(darkness * color.getSaturation(), 0.02f);
        float brightness = Math.max(darkness * color.getBrightness(), 0.02f);
        float[] rgb = Color.getHSBColor(color.getHue(), saturation, brightness).getComponents();
        VoidFogRenderer.setTarget(red, rgb[0]);
        VoidFogRenderer.setTarget(green, rgb[1]);
        VoidFogRenderer.setTarget(blue, rgb[2]);
    }

    public static void setupColor(Camera camera, Supplier<Float> red, Supplier<Float> green, Supplier<Float> blue, Consumer<Float> redSetter, Consumer<Float> greenSetter, Consumer<Float> blueSetter) {
        if (!((Boolean)CandyTweak.RENDER_VOID_FOG.get()).booleanValue() || !GameUtil.isInOverworld() || CameraUtil.isInFluid(camera)) {
            return;
        }
        if (VoidFogRenderer.isGameOverride(camera)) {
            VoidFogRenderer.setTarget(FOG_RED, red.get().floatValue());
            VoidFogRenderer.setTarget(FOG_GREEN, green.get().floatValue());
            VoidFogRenderer.setTarget(FOG_BLUE, blue.get().floatValue());
        } else {
            float DARKNESS = VoidFogRenderer.getDarknessValue(camera);
            Color OVERWORLD_COLOR = new Color(red.get().floatValue(), green.get().floatValue(), blue.get().floatValue());
            VoidFogRenderer.lerpColor(DARKNESS, OVERWORLD_COLOR, FOG_RED, FOG_GREEN, FOG_BLUE);
            VoidFogRenderer.lerpColor(DARKNESS, OVERWORLD_COLOR, SKY_RED, SKY_GREEN, SKY_BLUE);
            VoidFogRenderer.lerpColor(DARKNESS, OVERWORLD_COLOR, VOID_RED, VOID_GREEN, VOID_BLUE);
        }
        redSetter.accept(Float.valueOf(FOG_RED.lerpFloat()));
        greenSetter.accept(Float.valueOf(FOG_GREEN.lerpFloat()));
        blueSetter.accept(Float.valueOf(FOG_BLUE.lerpFloat()));
    }

    public static boolean setupFog(Camera camera, FogRenderer.FogMode fogMode, Supplier<Float> fogStart, Supplier<Float> fogEnd, Consumer<Float> fogStartSetter, Consumer<Float> fogEndSetter) {
        LivingEntity living;
        if (fogMode != FogRenderer.FogMode.FOG_TERRAIN || !((Boolean)CandyTweak.RENDER_VOID_FOG.get()).booleanValue() || !GameUtil.isInOverworld() || CameraUtil.isInFluid(camera)) {
            return false;
        }
        Entity entity = camera.m_90592_();
        boolean isDisabled = VoidFogRenderer.isDisabled(camera) || OverworldFogRenderer.isGameOverride(camera);
        float darkness = VoidFogRenderer.getDarknessValue(camera);
        float distance = VoidFogRenderer.getDistance(entity);
        float encroach = VoidFogRenderer.getDistanceDelta(entity);
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(MobEffects.f_19611_)) {
            distance *= 4.0f * GameRenderer.m_109108_((LivingEntity)living, (float)Minecraft.m_91087_().m_91296_());
        }
        float celestialTarget = !isDisabled && darkness < 0.5f && ClientLevelHelper.getSkyLight(entity) == 0 ? 0.0f : 1.0f;
        float cloudsTarget = !isDisabled && darkness < 0.5f && ClientLevelHelper.getSkyLight(entity) == 0 ? 0.0f : 1.0f;
        float starsTarget = !isDisabled && darkness < 0.5f && ClientLevelHelper.getSkyLight(entity) == 0 ? 0.0f : STARS_TRANSPARENCY.endFloat();
        float startTarget = Mth.m_14179_((float)Math.abs(darkness - 1.0f), (float)fogStart.get().floatValue(), (float)(VoidFogRenderer.getFogStart(camera, distance) * encroach));
        float endTarget = Mth.m_14179_((float)Math.abs(darkness - 1.0f), (float)fogEnd.get().floatValue(), (float)(VoidFogRenderer.getFogEnd(camera, distance) * encroach));
        VoidFogRenderer.setTarget(CELESTIAL_TRANSPARENCY, celestialTarget);
        VoidFogRenderer.setTarget(CLOUDS_TRANSPARENCY, cloudsTarget);
        VoidFogRenderer.setTarget(STARS_TRANSPARENCY, starsTarget);
        VoidFogRenderer.setTarget(FOG_START, Math.min(fogStart.get().floatValue(), isDisabled ? fogStart.get().floatValue() : startTarget));
        VoidFogRenderer.setTarget(FOG_END, Math.min(fogEnd.get().floatValue(), isDisabled ? fogEnd.get().floatValue() : endTarget));
        fogStartSetter.accept(Float.valueOf(FOG_START.lerpFloat()));
        fogEndSetter.accept(Float.valueOf(FOG_END.lerpFloat()));
        return !isDisabled || !FOG_START.isFinished() || !FOG_END.isFinished();
    }
}

