/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.light;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.timer.LerpTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public abstract class LightTextureHelper {
    private static final FlagHolder CACHE_INITIALIZER = FlagHolder.off();
    private static final LerpTimer[][] LIGHTMAP_TIMERS = new LerpTimer[16][16];

    public static void resetLightingCache() {
        CACHE_INITIALIZER.disable();
    }

    public static void setClassicTexture(NativeImage lightPixels) {
        for (int skyLight = 0; skyLight < 16; ++skyLight) {
            for (int blockLight = 0; blockLight < 16; ++blockLight) {
                if (skyLight >= 14 || blockLight >= 14) {
                    lightPixels.m_84988_(blockLight, skyLight, -1);
                    continue;
                }
                lightPixels.m_84988_(blockLight, skyLight, -6710887);
            }
        }
    }

    public static float getLightmapBrightness(int i, boolean isSkyLight) {
        float brightness;
        double gammaSetting = (Double)Minecraft.m_91087_().f_91066_.m_231927_().m_231551_();
        float light = 1.0f - (float)i / 15.0f;
        if (((Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get()).booleanValue()) {
            if (i <= 4 && !isSkyLight) {
                brightness = 3.0f;
            } else if (isSkyLight) {
                brightness = i >= 14 ? 0.0f : 2.6f;
            } else if (i < 14) {
                brightness = switch (i) {
                    case 13 -> 2.7f;
                    case 12 -> 3.0f;
                    default -> 3.4f;
                };
            } else {
                brightness = 1.8f;
            }
        } else if (i <= 4 && isSkyLight) {
            brightness = 2.6f;
        } else if (isSkyLight) {
            brightness = i >= 14 ? 0.0f : 2.6f;
        } else {
            brightness = switch (i) {
                case 15 -> 0.6f;
                case 14 -> 1.2f;
                case 13 -> 1.8f;
                case 11, 12 -> 2.4f;
                case 5, 9 -> 2.5f;
                case 4 -> 2.9f;
                default -> 2.6f;
            };
        }
        float lightmapBrightness = (1.0f - light) / (light * brightness + 1.0f) * 0.95f + 0.05f;
        if (gammaSetting > 0.0 && isSkyLight && i < 5 && ((Boolean)CandyTweak.DYNAMIC_LIGHT_BRIGHTNESS.get()).booleanValue()) {
            float ofGamma = switch (i) {
                case 1 -> 0.09f;
                case 2 -> 0.1f;
                case 3 -> 0.11f;
                case 4 -> 0.12f;
                default -> 0.08f;
            };
            float maxBrightness = LightTextureHelper.getLightmapBrightness(5, true) - 0.05f;
            float shiftBrightness = lightmapBrightness + (float)((double)ofGamma * gammaSetting);
            lightmapBrightness = Mth.m_14036_((float)shiftBrightness, (float)lightmapBrightness, (float)maxBrightness);
        }
        return lightmapBrightness;
    }

    public static int getSkylightSubtracted(ClientLevel level) {
        if (((Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get()).booleanValue()) {
            return 0;
        }
        boolean isNether = level.m_46472_() == Level.f_46429_ && (Boolean)CandyTweak.OLD_NETHER_LIGHTING.get() == false;
        float forceBrightness = isNether ? 7.0f : 15.0f;
        float skyDarken = 1.0f - (Mth.m_14089_((float)(level.m_46942_(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f);
        skyDarken = 1.0f - Mth.m_14036_((float)skyDarken, (float)0.0f, (float)1.0f);
        skyDarken = (float)((double)skyDarken * (1.0 - (double)(level.m_46722_(1.0f) * 5.0f) / 16.0));
        skyDarken = (float)((double)skyDarken * (1.0 - (double)(level.m_46661_(1.0f) * 5.0f) / 16.0));
        skyDarken = 1.0f - skyDarken;
        return (int)(skyDarken * (forceBrightness - 4.0f) + (15.0f - forceBrightness));
    }

    public static void setGrayscaleTexture(NativeImage lightPixels, float darknessEffect, float partialTick) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level == null || player == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        double gammaSetting = (Double)minecraft.f_91066_.m_231927_().m_231551_();
        float darkenAmount = minecraft.f_91063_.m_109131_(partialTick);
        float waterVision = player.m_108639_();
        float potionEffect = player.m_21023_(MobEffects.f_19611_) ? GameRenderer.m_109108_((LivingEntity)player, (float)partialTick) : (waterVision > 0.0f && player.m_21023_(MobEffects.f_19592_) ? waterVision : 0.0f);
        boolean isCacheInitialized = (Boolean)CACHE_INITIALIZER.get();
        boolean isSmoothTransition = (Boolean)CandyTweak.SMOOTH_LIGHT_TRANSITION.get() != false && (Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get() == false;
        boolean isGammaDisabled = (Boolean)CandyTweak.DISABLE_LIGHT_BRIGHTNESS.get();
        boolean isDynamicGamma = (Boolean)CandyTweak.DYNAMIC_LIGHT_BRIGHTNESS.get();
        boolean isFlashPresent = level.m_104819_() > 0 && (Boolean)minecraft.f_91066_.m_231935_().m_231551_() == false;
        boolean isWorldDarkening = darkenAmount > 0.0f;
        int skyLightSubtracted = LightTextureHelper.getSkylightSubtracted(level);
        if (isFlashPresent) {
            skyLightSubtracted = 1;
        } else if (isWorldDarkening) {
            skyLightSubtracted = Mth.m_14045_((int)(skyLightSubtracted + (int)Math.ceil(3.0f * darkenAmount)), (int)1, (int)15);
        }
        float ambientLight = level.m_6042_().f_63838_();
        float minSkyLight = LightTextureHelper.getLightmapBrightness(15, true) * ambientLight;
        float minBlockLight = LightTextureHelper.getLightmapBrightness(15, false) * ambientLight;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                float rgba;
                if (LIGHTMAP_TIMERS[x][y] == null) {
                    LightTextureHelper.LIGHTMAP_TIMERS[x][y] = LerpTimer.create(1L, TimeUnit.SECONDS);
                }
                float fromBlockLight = Math.max(LightTextureHelper.getLightmapBrightness(x, false), minBlockLight);
                float fromSkyLight = Math.max(LightTextureHelper.getLightmapBrightness(Math.max(y - skyLightSubtracted, 0), true), minSkyLight);
                if (level.m_46472_() == Level.f_46430_) {
                    fromSkyLight = 0.22f + fromSkyLight * 0.75f;
                }
                if (level.m_46472_() == Level.f_46429_) {
                    fromSkyLight = 0.05f + fromSkyLight * 0.75f;
                }
                if (potionEffect > 0.0f) {
                    float shiftBrightness = potionEffect * 0.7f;
                    float adjustBlockColor = (1.0f - fromBlockLight - 0.5f) * (shiftBrightness * fromBlockLight) + 0.5f * potionEffect;
                    float skyAdjust = (1.0f - fromSkyLight - 0.5f) * (shiftBrightness * fromSkyLight) + 0.5f * potionEffect;
                    fromBlockLight += adjustBlockColor;
                    fromSkyLight += skyAdjust;
                }
                if (darknessEffect > 0.0f && x != 15) {
                    fromBlockLight -= darknessEffect;
                    fromSkyLight -= darknessEffect;
                    fromBlockLight = Mth.m_14036_((float)fromBlockLight, (float)0.025f, (float)1.0f);
                    fromSkyLight = Mth.m_14036_((float)fromSkyLight, (float)0.025f, (float)1.0f);
                }
                double gamma = isGammaDisabled || isDynamicGamma ? 0.0 : gammaSetting;
                float skyLight = Mth.m_14036_((float)(fromSkyLight * 255.0f * ((float)gamma + 1.0f)), (float)6.375f, (float)255.0f);
                float blockLight = Mth.m_14036_((float)(fromBlockLight * 255.0f * ((float)gamma + 1.0f)), (float)6.375f, (float)255.0f);
                float f = rgba = fromBlockLight > fromSkyLight ? blockLight : skyLight;
                if (isSmoothTransition && isCacheInitialized) {
                    rgba = LIGHTMAP_TIMERS[x][y].setAndGetTarget(Float.valueOf(rgba), LerpTimer::lerpFloat).floatValue();
                }
                int light = Math.round(rgba);
                lightPixels.m_84988_(x, y, 0xFF000000 | light << 16 | light << 8 | light);
            }
        }
        if (!isCacheInitialized) {
            CACHE_INITIALIZER.enable();
        }
    }
}

