/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.light;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import mod.adrenix.nostalgic.helper.candy.block.ChestHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.data.IntegerHolder;
import mod.adrenix.nostalgic.util.common.data.Pair;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.world.BlockUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.Nullable;

public abstract class LightingHelper {
    private static final IntegerHolder TIME_SKYLIGHT = IntegerHolder.create(-1);
    private static final IntegerHolder WEATHER_SKYLIGHT = IntegerHolder.create(-1);
    private static final FlagHolder ENQUEUE_RELIGHT = FlagHolder.off();
    public static final ConcurrentHashMap<Block, Integer> LIGHT_BLOCK_CACHE = new ConcurrentHashMap();
    public static final ConcurrentLinkedDeque<Pair<Long, Byte>> PACKED_RELIGHT_QUEUE = new ConcurrentLinkedDeque();
    public static final ConcurrentLinkedDeque<Pair<Long, Long>> PACKED_CHUNK_BLOCK_QUEUE = new ConcurrentLinkedDeque();
    public static final FlagHolder RELIGHT_ALL_CHUNKS = FlagHolder.off();

    public static void init() {
        CandyTweak.OLD_WATER_LIGHTING.whenChanged(LightingHelper::invalidateAndRelight);
        CandyTweak.CHEST_LIGHT_BLOCK.whenChanged(LightingHelper::invalidateAndRelight);
    }

    private static void invalidateAndRelight() {
        LIGHT_BLOCK_CACHE.clear();
        RELIGHT_ALL_CHUNKS.enable();
    }

    public static void resetLightingCache() {
        TIME_SKYLIGHT.set(-1);
        WEATHER_SKYLIGHT.set(-1);
        ENQUEUE_RELIGHT.disable();
        PACKED_RELIGHT_QUEUE.clear();
        PACKED_CHUNK_BLOCK_QUEUE.clear();
    }

    public static boolean isRelightCheckEnqueued() {
        return (Boolean)ENQUEUE_RELIGHT.get();
    }

    public static void setRelightingAsFinished() {
        ENQUEUE_RELIGHT.disable();
    }

    public static void onTick() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        int skylightFromTime = LightingHelper.getSkyLightFromTime((Level)level);
        int skylightFromWeather = LightingHelper.getSkyLightFromWeather((Level)level);
        if ((Integer)TIME_SKYLIGHT.get() == -1 || (Integer)TIME_SKYLIGHT.get() != skylightFromTime) {
            TIME_SKYLIGHT.set(skylightFromTime);
            ENQUEUE_RELIGHT.enable();
        }
        if ((Integer)WEATHER_SKYLIGHT.get() == -1 || (Integer)WEATHER_SKYLIGHT.get() != skylightFromWeather) {
            WEATHER_SKYLIGHT.set(skylightFromWeather);
            if ((Integer)TIME_SKYLIGHT.get() > 4) {
                ENQUEUE_RELIGHT.enable();
            }
        }
    }

    public static int getNonEmissiveLightColor(BlockAndTintGetter level, BlockPos blockPos) {
        int skyLight = level.m_45517_(LightLayer.SKY, blockPos);
        int blockLight = level.m_45517_(LightLayer.BLOCK, blockPos);
        return skyLight << 20 | blockLight << 4;
    }

    public static int getWaterLight(BlockAndTintGetter level, BlockPos blockPos) {
        int center = LightingHelper.getNonEmissiveLightColor(level, blockPos);
        int above = LightingHelper.getNonEmissiveLightColor(level, blockPos.m_7494_());
        int below = LightingHelper.getNonEmissiveLightColor(level, blockPos.m_7495_());
        int north = LightingHelper.getNonEmissiveLightColor(level, blockPos.m_122012_());
        int south = LightingHelper.getNonEmissiveLightColor(level, blockPos.m_122019_());
        int west = LightingHelper.getNonEmissiveLightColor(level, blockPos.m_122024_());
        int east = LightingHelper.getNonEmissiveLightColor(level, blockPos.m_122029_());
        return MathUtil.getLargest(center, above, below, north, south, west, east);
    }

    public static int getSkyLightFromTime(Level level) {
        if (level.m_6042_().f_63856_() || !level.m_6042_().f_223549_()) {
            return 0;
        }
        float time = level.m_46942_(1.0f) * ((float)Math.PI * 2);
        int skyLight = 15;
        if (MathUtil.isInRange(time, 1.8235918f, 4.459594f)) {
            skyLight = 4;
        } else if (MathUtil.isInRange(time, 4.459884f, 4.5061855f) || MathUtil.isInRange(time, 1.7769997f, 1.8233016f)) {
            skyLight = 5;
        } else if (MathUtil.isInRange(time, 4.5064745f, 4.55252f) || MathUtil.isInRange(time, 1.7306658f, 1.7767112f)) {
            skyLight = 6;
        } else if (MathUtil.isInRange(time, 4.552807f, 4.5983024f) || MathUtil.isInRange(time, 1.684883f, 1.7303787f)) {
            skyLight = 7;
        } else if (MathUtil.isInRange(time, 4.598588f, 4.6440983f) || MathUtil.isInRange(time, 1.6390872f, 1.6845976f)) {
            skyLight = 8;
        } else if (MathUtil.isInRange(time, 4.6443815f, 4.689612f) || MathUtil.isInRange(time, 1.5938551f, 1.6388037f)) {
            skyLight = 9;
        } else if (MathUtil.isInRange(time, 4.6898937f, 4.735117f) || MathUtil.isInRange(time, 1.548349f, 1.5935733f)) {
            skyLight = 10;
        } else if (MathUtil.isInRange(time, 4.7353964f, 4.7805977f) || MathUtil.isInRange(time, 1.5028657f, 1.548069f)) {
            skyLight = 11;
        } else if (MathUtil.isInRange(time, 4.780876f, 4.826043f) || MathUtil.isInRange(time, 1.4571424f, 1.5025874f)) {
            skyLight = 12;
        } else if (MathUtil.isInRange(time, 4.826319f, 4.8719864f) || MathUtil.isInRange(time, 1.4111987f, 1.4568661f)) {
            skyLight = 13;
        } else if (MathUtil.isInRange(time, 4.8722606f, 4.9184027f) || MathUtil.isInRange(time, 1.3650552f, 1.4109247f)) {
            skyLight = 14;
        }
        return skyLight;
    }

    public static int getSkyLightFromWeather(Level level) {
        float partialTick = Minecraft.m_91087_().m_91296_();
        float rain = level.m_46722_(partialTick);
        float thunder = level.m_46661_(partialTick);
        int rainDiff = 0;
        int thunderDiff = 0;
        if (rain >= 0.3f) {
            rainDiff = 1;
        }
        if (rain >= 0.6f) {
            rainDiff = 2;
        }
        if (rain >= 0.9f) {
            rainDiff = 3;
        }
        if (thunder >= 0.8f) {
            thunderDiff = 5;
        }
        return Math.max(rainDiff, thunderDiff);
    }

    public static int getCombinedLight(int skyLight, int blockLight) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || skyLight <= 0) {
            return 0;
        }
        int maxLightLevel = level.m_7469_();
        int lightFromTime = (Integer)TIME_SKYLIGHT.get();
        int weatherDiff = (Integer)WEATHER_SKYLIGHT.get();
        int minSkyLight = Math.max(0, (level.m_6042_().m_63967_() ? lightFromTime : maxLightLevel) - 11);
        int minLight = skyLight >= maxLightLevel ? minSkyLight : 0;
        int maxLight = Math.max(blockLight, (Integer)CandyTweak.MAX_BLOCK_LIGHT.get());
        int oldSkyLight = lightFromTime - weatherDiff;
        int offsetSkyLight = maxLightLevel - skyLight;
        if (skyLight != maxLightLevel && oldSkyLight <= minSkyLight) {
            oldSkyLight += weatherDiff;
        }
        return Mth.m_14045_((int)Math.max(oldSkyLight - offsetSkyLight, blockLight), (int)minLight, (int)maxLight);
    }

    public static int getClassicLight(int skyLight, ClientLevel level, BlockPos blockPos) {
        BlockPos abovePos = blockPos.m_7494_();
        if (!level.m_6042_().f_223549_()) {
            return 0;
        }
        if (skyLight >= level.m_7469_() || skyLight <= 0) {
            return skyLight;
        }
        while (abovePos.m_123342_() < level.m_151558_()) {
            boolean isSolid;
            BlockState blockState = level.m_8055_(abovePos);
            boolean isWater = blockState.m_60713_(Blocks.f_49990_);
            boolean bl = isSolid = level.m_8055_(abovePos).m_60739_((BlockGetter)level, abovePos) >= level.m_7469_();
            if (isWater || isSolid) {
                return 0;
            }
            abovePos = abovePos.m_7494_();
        }
        return level.m_7469_();
    }

    public static void findBlocks(LevelChunk chunk, Predicate<BlockState> predicate, BiConsumer<BlockPos, BlockState> output) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = chunk.m_151560_(); i < chunk.m_151561_(); ++i) {
            LevelChunkSection section = chunk.m_183278_(chunk.m_151566_(i));
            BlockPos blockPos = SectionPos.m_123196_((ChunkPos)chunk.m_7697_(), (int)i).m_123249_();
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        BlockState blockState = section.m_62982_(x, y, z);
                        if (!predicate.test(blockState)) continue;
                        output.accept((BlockPos)mutablePos.m_122154_((Vec3i)blockPos, x, y, z), blockState);
                    }
                }
            }
        }
    }

    public static void relightChunk(@Nullable LevelChunk chunk, byte allChanged) {
        if (chunk == null) {
            return;
        }
        boolean isChestLightBlocked = (Boolean)CandyTweak.CHEST_LIGHT_BLOCK.get();
        boolean isWaterDarker = (Boolean)CandyTweak.OLD_WATER_LIGHTING.get();
        if (!isChestLightBlocked && !isWaterDarker && allChanged != 1) {
            return;
        }
        CompletableFuture.runAsync(() -> LightingHelper.findBlocks(chunk, blockState -> {
            if (allChanged == 1) {
                return BlockUtil.isWaterLike(blockState) || BlockUtil.isChestLike(blockState);
            }
            boolean relightChest = isChestLightBlocked && ChestHelper.isOld(blockState);
            boolean relightWater = isWaterDarker && BlockUtil.isWaterLike(blockState);
            return relightChest || relightWater;
        }, (blockPos, blockState) -> {
            long packedChunk = chunk.m_7697_().m_45588_();
            long packedBlock = blockPos.m_121878_();
            PACKED_CHUNK_BLOCK_QUEUE.add(new Pair<Long, Long>(packedChunk, packedBlock));
        }), Util.m_183991_());
    }
}

