/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.candy.screen.inventory;

import mod.adrenix.nostalgic.helper.candy.screen.inventory.SlotTracker;
import mod.adrenix.nostalgic.mixin.access.AbstractContainerScreenAccess;
import mod.adrenix.nostalgic.mixin.access.ScreenAccess;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.InventoryShield;
import mod.adrenix.nostalgic.tweak.enums.RecipeBook;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.LocateResource;
import mod.adrenix.nostalgic.util.common.asset.ModSprite;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.sprite.WidgetSprites;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryScreenHelper {
    private static final WidgetSprites SMALL_RECIPE_BUTTON = new WidgetSprites(ModSprite.RECIPE_BUTTON_SMALL, ModSprite.RECIPE_BUTTON_SMALL_HIGHLIGHTED);
    private static final WidgetSprites LARGE_RECIPE_BUTTON = new WidgetSprites(ModSprite.RECIPE_BUTTON_LARGE, ModSprite.RECIPE_BUTTON_LARGE_HIGHLIGHTED);

    @Nullable
    public static Slot setPositionsForSlots(NonNullList<Slot> slots, RecipeBookComponent recipes) {
        InventoryShield shield = (InventoryShield)CandyTweak.INVENTORY_SHIELD.get();
        Slot offHand = null;
        for (Slot slot : slots) {
            SlotTracker.CRAFT_TOP_LEFT.moveOrReset(slot, 88, 26);
            SlotTracker.CRAFT_TOP_RIGHT.moveOrReset(slot, 106, 26);
            SlotTracker.CRAFT_BOTTOM_LEFT.moveOrReset(slot, 88, 44);
            SlotTracker.CRAFT_BOTTOM_RIGHT.moveOrReset(slot, 106, 44);
            SlotTracker.CRAFT_RESULT.moveOrReset(slot, 144, 36);
            if (!SlotTracker.OFF_HAND.isEqualTo(slot)) continue;
            offHand = slot;
            if (InventoryShield.MODERN == shield) {
                SlotTracker.OFF_HAND.moveOrReset(slot, 152, 62);
            }
            switch (shield) {
                case INVISIBLE: {
                    SlotTracker.OFF_HAND.move(slot, -9999, -9999);
                    break;
                }
                case MIDDLE_RIGHT: {
                    SlotTracker.OFF_HAND.move(slot, 152, 62);
                    break;
                }
                case BOTTOM_LEFT: {
                    if (recipes.m_100385_()) {
                        SlotTracker.OFF_HAND.move(slot, 174, 142);
                        break;
                    }
                    SlotTracker.OFF_HAND.move(slot, -14, 142);
                }
            }
        }
        return offHand;
    }

    private static ImageButton getLargeBook(AbstractContainerScreenAccess inventory, ImageButton original) {
        return new SpriteButton(inventory.nt$getLeftPos() + 151, inventory.nt$getTopPos() + 7, 18, 18, LARGE_RECIPE_BUTTON, button -> {
            original.m_5691_();
            button.m_264152_(inventory.nt$getLeftPos() + 151, inventory.nt$getTopPos() + 7);
        });
    }

    private static ImageButton getSmallBook(AbstractContainerScreenAccess inventory, ImageButton original) {
        return new SpriteButton(inventory.nt$getLeftPos() + 160, inventory.nt$getTopPos() + 7, 9, 10, SMALL_RECIPE_BUTTON, button -> {
            original.m_5691_();
            button.m_264152_(inventory.nt$getLeftPos() + 160, inventory.nt$getTopPos() + 7);
        });
    }

    public static void setRecipeButton(AbstractContainerScreenAccess inventory, RecipeBook book) {
        ImageButton recipeButton = null;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null) {
            throw new NullPointerException("Tried adding recipe book button to a null screen");
        }
        for (GuiEventListener widget : screen.m_6702_()) {
            ImageButton button;
            if (!(widget instanceof ImageButton)) continue;
            recipeButton = button = (ImageButton)widget;
            break;
        }
        if (recipeButton == null) {
            return;
        }
        switch (book) {
            case DISABLED: {
                recipeButton.f_93623_ = false;
                recipeButton.f_93624_ = false;
                break;
            }
            case LARGE: {
                ((ScreenAccess)screen).nt$removeWidget((GuiEventListener)recipeButton);
                ((ScreenAccess)screen).nt$addRenderableWidget(InventoryScreenHelper.getLargeBook(inventory, recipeButton));
                break;
            }
            case SMALL: {
                ((ScreenAccess)screen).nt$removeWidget((GuiEventListener)recipeButton);
                ((ScreenAccess)screen).nt$addRenderableWidget(InventoryScreenHelper.getSmallBook(inventory, recipeButton));
            }
        }
    }

    public static void renderOffHandSlot(GuiGraphics graphics, RecipeBookComponent recipes, @Nullable Slot offHand, int leftPos, int height) {
        boolean isModernOverride;
        InventoryShield shield = (InventoryShield)CandyTweak.INVENTORY_SHIELD.get();
        boolean bl = isModernOverride = (Boolean)CandyTweak.OLD_INVENTORY.get() != false && shield == InventoryShield.MODERN;
        if (InventoryShield.BOTTOM_LEFT == shield && offHand != null) {
            if (recipes.m_100385_()) {
                graphics.m_280218_(TextureLocation.INVENTORY, leftPos + 172, height / 2 + 51, 200, 33, 26, 32);
                SlotTracker.OFF_HAND.move(offHand, 174, 142);
            } else {
                graphics.m_280218_(TextureLocation.INVENTORY, leftPos - 22, height / 2 + 51, 200, 0, 25, 32);
                SlotTracker.OFF_HAND.move(offHand, -14, 142);
            }
        } else if (InventoryShield.MIDDLE_RIGHT == shield || isModernOverride) {
            graphics.m_280218_(TextureLocation.INVENTORY, leftPos + 151, height / 2 - 22, 178, 56, 18, 18);
        }
        if (!((Boolean)CandyTweak.OLD_INVENTORY.get()).booleanValue() && InventoryShield.MODERN != shield) {
            graphics.m_280218_(TextureLocation.INVENTORY, leftPos + 76, height / 2 - 22, 178, 74, 18, 18);
        }
    }

    private static class SpriteButton
    extends ImageButton {
        private final WidgetSprites sprites;

        private SpriteButton(int x, int y, int width, int height, WidgetSprites sprites, Button.OnPress onPress) {
            super(x, y, width, height, 0, 0, LocateResource.game("textures/gui/recipe_button"), onPress);
            this.sprites = sprites;
        }

        public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            RenderUtil.blitSprite(this.sprites.get(this.m_142518_(), this.m_198029_()), graphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        }
    }
}

