/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

public abstract class BoatHelper {
    public static boolean isWaterLift(Boat.Status status) {
        return status == Boat.Status.UNDER_WATER || status == Boat.Status.UNDER_FLOWING_WATER;
    }

    public static double getGravityAmount(Boat boat, Boat.Status status) {
        return boat.m_20184_().f_82480_ + (boat.m_20068_() || BoatHelper.isWaterLift(status) ? 0.0 : -0.04);
    }

    public static double getLiftAmount(double y) {
        return Mth.m_14008_((double)(y + 0.025), (double)y, (double)0.5);
    }

    public static void applyParticles(Boat boat) {
        Vec3 movement = boat.m_20184_();
        double motionX = movement.f_82479_;
        double motionY = movement.f_82480_;
        double motionZ = movement.f_82481_;
        double prevDistance = Math.sqrt(motionX * motionX + motionZ * motionZ);
        if (prevDistance > 0.2625) {
            RandomSource randomSource = RandomSource.m_216327_();
            Vec3 position = boat.m_20182_();
            double posX = position.f_82479_;
            double posY = position.f_82480_;
            double posZ = position.f_82481_;
            double rotationYaw = boat.m_146908_();
            double x = Math.cos(rotationYaw * Math.PI / 180.0);
            double y = Math.sin(rotationYaw * Math.PI / 180.0);
            int i = 0;
            while ((double)i < 1.0 + prevDistance * 60.0) {
                double randX = randomSource.m_188501_() * 2.0f - 1.0f;
                double randY = (double)(randomSource.m_188503_(2) * 2 - 1) * 0.7;
                if (randomSource.m_188499_()) {
                    double px = posX - x * randX * 0.8 + y * randY;
                    double py = posY + 0.5;
                    double pz = posZ - y * randX * 0.8 - x * randY;
                    boat.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, px, py, pz, motionX, motionY, motionZ);
                }
                ++i;
            }
        }
    }
}

