/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay;

import mod.adrenix.nostalgic.mixin.access.FireBlockAccess;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public abstract class FireBlockHelper {
    private static void checkBurnOut(FireBlockAccess fire, ServerLevel level, BlockPos blockPos, RandomSource randomSource, int randomizeBound) {
        BlockState blockState = level.m_8055_(blockPos);
        int burnOdds = fire.nt$getBurnOdds(blockState);
        if (randomSource.m_188503_(randomizeBound) < burnOdds) {
            if (randomSource.m_188503_(2) == 0 && !level.m_46758_(blockPos)) {
                level.m_7731_(blockPos, fire.nt$getStateWithAge((LevelAccessor)level, blockPos, 0), 3);
            } else {
                level.m_7471_(blockPos, false);
            }
            if (blockState.m_60734_() instanceof TntBlock) {
                TntBlock.m_57433_((Level)level, (BlockPos)blockPos);
            }
        }
    }

    public static void tick(FireBlockAccess fire, ServerLevel level, BlockPos blockPos, BlockState blockState, RandomSource randomSource, CallbackInfo callback) {
        int nextAge;
        BlockPos belowPos = blockPos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        boolean isAboveInfiniteBurn = belowState.m_204336_(level.m_6042_().f_63836_());
        int fireAge = (Integer)blockState.m_61143_((Property)FireBlock.f_53408_);
        if (fireAge != (nextAge = Math.min(15, fireAge + 1))) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)FireBlock.f_53408_, (Comparable)Integer.valueOf(nextAge)), 4);
        }
        if (!isAboveInfiniteBurn) {
            if (!fire.nt$isValidFireLocation((BlockGetter)level, blockPos)) {
                if (!level.m_8055_(belowPos).m_60783_((BlockGetter)level, belowPos, Direction.UP) || fireAge > 3) {
                    level.m_7471_(blockPos, false);
                }
                callback.cancel();
                return;
            }
            if (fireAge == 15 && randomSource.m_188503_(4) == 0 && !fire.nt$canBurn(belowState)) {
                level.m_7471_(blockPos, false);
                callback.cancel();
                return;
            }
        }
        if (fireAge % 2 == 0 && fireAge > 2) {
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_122029_(), randomSource, 300);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_122024_(), randomSource, 300);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_7495_(), randomSource, 250);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_7494_(), randomSource, 250);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_122012_(), randomSource, 300);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_122019_(), randomSource, 300);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                    for (int offsetY = -1; offsetY <= 4; ++offsetY) {
                        if (offsetX == 0 && offsetY == 0 && offsetZ == 0) continue;
                        int bound = 100;
                        if (offsetY > 1) {
                            bound += (offsetY - 1) * 100;
                        }
                        mutablePos.m_122154_((Vec3i)blockPos, offsetX, offsetY, offsetZ);
                        int igniteOdds = fire.nt$getIgniteOdds((LevelReader)level, (BlockPos)mutablePos);
                        if (igniteOdds <= 0 || randomSource.m_188503_(bound) > igniteOdds || level.m_46471_() && fire.nt$isNearRain((Level)level, (BlockPos)mutablePos)) continue;
                        level.m_7731_((BlockPos)mutablePos, fire.nt$getStateWithAge((LevelAccessor)level, (BlockPos)mutablePos, 0), 3);
                    }
                }
            }
        }
        if (fireAge == 15 && !((Boolean)GameplayTweak.INFINITE_BURN.get()).booleanValue()) {
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_122029_(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_122024_(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_7495_(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_7494_(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_122012_(), randomSource, 1);
            FireBlockHelper.checkBurnOut(fire, level, blockPos.m_122019_(), randomSource, 1);
        }
        callback.cancel();
    }
}

