/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mod.adrenix.nostalgic.mixin.access.SheepAccess;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.factory.TweakFlag;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class MobLootHelper {
    private static final Map<EntityType<?>, EntityLoot> LOOT_MAP = new HashMap();
    private static final Function<ItemLike, LootTable> WOOL_TABLE = Util.m_143827_(item -> MobLootHelper.makeTable(item, 1));
    private static final LootTable COOKED_PORK_CHOP_TABLE = MobLootHelper.makeTable((ItemLike)Items.f_42486_, 2);
    private static final LootTable FEATHER_TABLE = MobLootHelper.makeTable((ItemLike)Items.f_42402_, 2);
    private static final LootTable STRING_TABLE = MobLootHelper.makeTable((ItemLike)Items.f_42401_, 2);
    private static final LootTable LEATHER_TABLE = MobLootHelper.makeTable((ItemLike)Items.f_42454_, 2);
    private static final LootTable RABBIT_HIDE_TABLE = MobLootHelper.makeTable((ItemLike)Items.f_42649_, 1);
    private static final LootTable PORK_CHOP_TABLE = MobLootHelper.makePorkTable();
    private static final LootTable ARROW_BONE_TABLE = MobLootHelper.makeSkeletonTable();

    private static LootTable.Builder addToTable(LootTable.Builder builder, ItemLike item, int max, boolean canSmelt) {
        if (canSmelt) {
            return builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)max))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_()))))));
        }
        return builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)max))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))));
    }

    private static LootTable makeTable(ItemLike item, int max) {
        return MobLootHelper.addToTable(LootTable.m_79147_(), item, max, false).m_79167_();
    }

    private static LootTable makePorkTable() {
        return MobLootHelper.addToTable(LootTable.m_79147_(), (ItemLike)Items.f_42485_, 2, true).m_79167_();
    }

    private static LootTable makeSkeletonTable() {
        LootTable.Builder builder = LootTable.m_79147_();
        MobLootHelper.addToTable(builder, (ItemLike)Items.f_42412_, 2, false);
        MobLootHelper.addToTable(builder, (ItemLike)Items.f_42500_, 2, false);
        return builder.m_79167_();
    }

    public static void init() {
        new EntityLoot(EntityType.f_20531_, GameplayTweak.OLD_ZOMBIE_PIGMEN_DROPS, COOKED_PORK_CHOP_TABLE);
        new EntityLoot(EntityType.f_20501_, GameplayTweak.OLD_ZOMBIE_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.f_20530_, GameplayTweak.OLD_STYLE_ZOMBIE_VILLAGER_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.f_20562_, GameplayTweak.OLD_STYLE_DROWNED_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.f_20458_, GameplayTweak.OLD_STYLE_HUSK_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.f_20479_, GameplayTweak.OLD_SPIDER_DROPS, STRING_TABLE);
        new EntityLoot(EntityType.f_20554_, GameplayTweak.OLD_STYLE_CAVE_SPIDER_DROPS, STRING_TABLE);
        new EntityLoot(EntityType.f_20557_, GameplayTweak.OLD_COW_DROPS, LEATHER_TABLE);
        new EntityLoot(EntityType.f_20504_, GameplayTweak.OLD_STYLE_MOOSHROOM_DROPS, LEATHER_TABLE);
        new EntityLoot(EntityType.f_20517_, GameplayTweak.OLD_STYLE_RABBIT_DROPS, RABBIT_HIDE_TABLE);
        new EntityLoot(EntityType.f_20555_, GameplayTweak.OLD_CHICKEN_DROPS, FEATHER_TABLE);
        new EntityLoot(EntityType.f_20510_, GameplayTweak.OLD_PIG_DROPS, PORK_CHOP_TABLE);
        new EntityLoot(EntityType.f_20481_, GameplayTweak.OLD_STYLE_STRAY_DROPS, ARROW_BONE_TABLE);
    }

    public static LootTable getTable(Entity entity, LootTable vanilla) {
        EntityType entityType = entity.m_6095_();
        if (LOOT_MAP.containsKey(entityType)) {
            return LOOT_MAP.get(entityType).getTable(vanilla);
        }
        if (entityType == EntityType.f_20520_ && ((Boolean)GameplayTweak.OLD_SHEEP_DROPS.get()).booleanValue()) {
            Sheep sheep = (Sheep)entityType.m_141992_(entity);
            if (sheep != null && !sheep.m_29875_()) {
                return WOOL_TABLE.apply(SheepAccess.NT$ITEM_BY_DYE().get(sheep.m_29874_()));
            }
            return LootTable.f_79105_;
        }
        return vanilla;
    }

    private record EntityLoot(EntityType<?> entityType, TweakFlag tweak, LootTable lootTable) {
        EntityLoot(EntityType<?> entityType, TweakFlag tweak, LootTable lootTable) {
            LOOT_MAP.put(entityType, this);
            this.entityType = entityType;
            this.tweak = tweak;
            this.lootTable = lootTable;
        }

        LootTable getTable(LootTable vanilla) {
            if (((Boolean)this.tweak.get()).booleanValue()) {
                return this.lootTable;
            }
            return vanilla;
        }
    }
}

