/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay.stamina;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaHelper;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.enums.StaminaRegain;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;

public class StaminaData {
    public static final int MAX_STAMINA_LEVEL = 20;
    private boolean tickAgain = false;
    private boolean isExhausted = false;
    private int durationInTicks = 0;
    private int rechargeInTicks = 0;
    private int cooldownInTicks = 0;
    private int halfRateInTicks = 0;
    private int waitTimer = 0;
    private int tickTimer = 0;
    private int staminaLevel = 20;

    public StaminaData() {
        this.syncTickTimers();
    }

    public void syncTickTimers() {
        int durationFromTweak = (Integer)GameplayTweak.STAMINA_DURATION.get() * 20;
        int rechargeFromTweak = (Integer)GameplayTweak.STAMINA_RECHARGE.get() * 20;
        int cooldownFromTweak = (Integer)GameplayTweak.STAMINA_COOLDOWN.get() * 20;
        if (this.durationInTicks != durationFromTweak) {
            this.durationInTicks = durationFromTweak;
            this.tickTimer = durationFromTweak;
            this.waitTimer = 0;
            this.halfRateInTicks = 0;
        }
        if (this.rechargeInTicks != rechargeFromTweak) {
            this.rechargeInTicks = rechargeFromTweak;
        }
        if (this.cooldownInTicks != cooldownFromTweak) {
            this.cooldownInTicks = cooldownFromTweak;
        }
    }

    public void tick(Player player) {
        boolean canTick;
        Difficulty difficulty = player.m_9236_().m_46791_();
        boolean isSprinting = player.m_20142_();
        boolean bl = canTick = player.m_9236_().m_5776_() || NostalgicTweaks.isServer();
        if (((Boolean)GameplayTweak.STAMINA_INFINITE_PEACEFUL.get()).booleanValue() && difficulty == Difficulty.PEACEFUL) {
            this.staminaLevel = 20;
            return;
        }
        this.syncTickTimers();
        if (this.isExhausted) {
            if (canTick && this.canRegain(player) && this.isNotHalfRate(player)) {
                ++this.tickTimer;
            }
            if (this.tickTimer >= this.rechargeInTicks) {
                this.isExhausted = false;
                this.tickTimer = this.durationInTicks;
                this.waitTimer = 0;
            }
            this.setStaminaLevel(this.isExhausted ? this.rechargeInTicks : this.durationInTicks);
        } else if (isSprinting) {
            if (canTick) {
                --this.tickTimer;
            }
            this.waitTimer = this.cooldownInTicks;
            if (this.tickTimer <= 0) {
                this.isExhausted = true;
                this.tickTimer = 0;
            }
            this.setStaminaLevel(this.durationInTicks);
        } else {
            if (this.tickTimer < this.durationInTicks && canTick) {
                if (this.waitTimer <= 0 && this.canRegain(player) && this.isNotHalfRate(player)) {
                    ++this.tickTimer;
                } else {
                    --this.waitTimer;
                }
            }
            this.setStaminaLevel(this.durationInTicks);
        }
        boolean shouldTickAgain = this.hasPositiveEffect(player);
        if (this.hasNegativeEffect(player) && isSprinting) {
            shouldTickAgain = true;
        }
        if (shouldTickAgain && !this.tickAgain) {
            this.tickAgain = true;
            this.tick(player);
        } else {
            this.tickAgain = false;
        }
    }

    private void setStaminaLevel(int amountInTicks) {
        this.staminaLevel = (int)Math.ceil((double)this.tickTimer / (double)amountInTicks * 20.0);
    }

    private boolean isMoving(Player player) {
        double dz;
        double dx = player.m_20185_() - player.f_19854_;
        return dx * dx + (dz = player.m_20189_() - player.f_19856_) * dz > (double)2.5E-7f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isNotHalfRate(Player player) {
        boolean isHalfRate = false;
        boolean hasHunger = false;
        if (GameplayTweak.STAMINA_REGAIN_WHEN_MOVING.get() == StaminaRegain.HALF && this.isMoving(player)) {
            boolean bl = isHalfRate = !player.m_20142_() && this.staminaLevel < 20;
        }
        if (((Boolean)GameplayTweak.STAMINA_HUNGER_EFFECT.get()).booleanValue()) {
            hasHunger = player.m_21023_(MobEffects.f_19612_);
        }
        if (!isHalfRate && !hasHunger) {
            this.halfRateInTicks = 0;
            return true;
        }
        if (this.halfRateInTicks >= 1) {
            this.halfRateInTicks = 0;
            return true;
        }
        ++this.halfRateInTicks;
        return false;
    }

    private boolean canRegain(Player player) {
        if (GameplayTweak.STAMINA_REGAIN_WHEN_MOVING.get() != StaminaRegain.NONE) {
            return true;
        }
        return !this.isMoving(player);
    }

    public boolean cannotRegain(Player player) {
        return !this.canRegain(player) && !player.m_20142_() && this.staminaLevel < 20;
    }

    public boolean hasPositiveEffect(Player player) {
        if (((Boolean)GameplayTweak.STAMINA_SATURATION_EFFECT.get()).booleanValue() && StaminaHelper.isActiveFor(player)) {
            return player.m_21023_(MobEffects.f_19618_) && !player.m_20142_();
        }
        return false;
    }

    public boolean hasNegativeEffect(Player player) {
        if (((Boolean)GameplayTweak.STAMINA_HUNGER_EFFECT.get()).booleanValue() && StaminaHelper.isActiveFor(player)) {
            return player.m_21023_(MobEffects.f_19612_);
        }
        return false;
    }

    public int getStaminaLevel() {
        return this.staminaLevel;
    }

    public boolean isCooldown() {
        if (!((Boolean)GameplayTweak.STAMINA_SPRINT.get()).booleanValue()) {
            return false;
        }
        return this.waitTimer > 0 && this.waitTimer < this.cooldownInTicks;
    }

    public boolean isExhausted() {
        if (!((Boolean)GameplayTweak.STAMINA_SPRINT.get()).booleanValue()) {
            return false;
        }
        return this.isExhausted;
    }
}

