/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.gameplay.stamina;

import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaData;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.asset.ModSprite;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.sprite.GuiSprite;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class StaminaRenderer {
    public static boolean isVisible() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || ((Boolean)CandyTweak.HIDE_STAMINA_BAR.get()).booleanValue() || !((Boolean)GameplayTweak.STAMINA_SPRINT.get()).booleanValue()) {
            return false;
        }
        if (((Boolean)CandyTweak.HIDE_STAMINA_BAR_INACTIVE.get()).booleanValue() && !StaminaHelper.isActiveFor((Player)player)) {
            return false;
        }
        Entity vehicle = player.m_20202_();
        boolean isMounted = vehicle != null && vehicle.m_20152_();
        boolean isInSurvival = minecraft.f_91072_ != null && minecraft.f_91072_.m_105205_();
        boolean isPlayerCamera = minecraft.m_91288_() instanceof Player;
        return !minecraft.f_91066_.f_92062_ && !isMounted && isInSurvival && isPlayerCamera;
    }

    public static void render(GuiGraphics graphics, int rightHeight) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || !StaminaRenderer.isVisible()) {
            return;
        }
        RenderUtil.beginBatching();
        StaminaData data = StaminaHelper.get((Player)player);
        int width = GuiUtil.getGuiWidth();
        int height = GuiUtil.getGuiHeight();
        int left = width / 2 + 91;
        int top = height - rightHeight;
        int stamina = data.getStaminaLevel();
        boolean isCooldown = data.isCooldown();
        boolean isExhausted = data.isExhausted();
        boolean hasPositiveEffect = data.hasPositiveEffect((Player)player);
        boolean hasNegativeEffect = data.hasNegativeEffect((Player)player);
        boolean cannotRegain = data.cannotRegain((Player)player);
        for (int i = 0; i < 10; ++i) {
            GuiSprite sprite = isExhausted ? ModSprite.STAMINA_RECHARGE : ModSprite.STAMINA_LEVEL;
            int x = left - i * 8 - 9;
            int icon = i * 2 + 1;
            if (hasPositiveEffect) {
                sprite = ModSprite.STAMINA_POSITIVE;
            }
            if (cannotRegain && !((Boolean)CandyTweak.HIDE_STAMINA_BAR_MOVING.get()).booleanValue()) {
                sprite = ModSprite.STAMINA_NEGATIVE;
            }
            if (hasNegativeEffect) {
                sprite = ModSprite.STAMINA_NEGATIVE;
            }
            if (isCooldown && !((Boolean)CandyTweak.HIDE_STAMINA_BAR_COOLDOWN.get()).booleanValue()) {
                sprite = ModSprite.STAMINA_COOLING;
            }
            RenderUtil.blitSprite(ModSprite.STAMINA_EMPTY, graphics, x, top);
            if (icon > stamina) {
                sprite = ModSprite.STAMINA_EMPTY;
            } else if (icon == stamina && MathUtil.isOdd(stamina)) {
                GuiSprite guiSprite = sprite = isExhausted ? ModSprite.STAMINA_RECHARGE_HALF : ModSprite.STAMINA_LEVEL_HALF;
                if (hasPositiveEffect) {
                    sprite = ModSprite.STAMINA_POSITIVE_HALF;
                }
                if (cannotRegain && !((Boolean)CandyTweak.HIDE_STAMINA_BAR_MOVING.get()).booleanValue()) {
                    sprite = ModSprite.STAMINA_NEGATIVE_HALF;
                }
                if (hasNegativeEffect) {
                    sprite = ModSprite.STAMINA_NEGATIVE_HALF;
                }
                if (isCooldown && !((Boolean)CandyTweak.HIDE_STAMINA_BAR_COOLDOWN.get()).booleanValue()) {
                    sprite = ModSprite.STAMINA_COOLING_HALF;
                }
            }
            RenderUtil.blitSprite(sprite, graphics, x, top);
        }
        RenderUtil.endBatching();
    }
}

