/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.sound;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class CaveSoundManager {
    private int tickCountdown;
    private final RandomSource randomSource;
    private final SoundManager soundManager;
    private final LocalPlayer player;
    private final ClientLevel level;

    public CaveSoundManager(LocalPlayer player, SoundManager soundManager) {
        this.player = player;
        this.level = player.f_108545_;
        this.randomSource = player.f_108545_.m_213780_();
        this.soundManager = soundManager;
        this.tickCountdown = this.randomSource.m_188503_(12000);
    }

    public static SimpleSoundInstance getSound(RandomSource randomSource, double x, double y, double z) {
        return new SimpleSoundInstance(new ResourceLocation("nostalgic_tweaks", "cave"), SoundSource.AMBIENT, 0.7f, 0.8f + randomSource.m_188501_() * 0.2f, randomSource, false, 0, SoundInstance.Attenuation.LINEAR, x, y, z, false);
    }

    public void tickAndPlayIfPossible(BlockPos blockPos) {
        if (this.tickCountdown > 0) {
            --this.tickCountdown;
        }
        if (this.tickCountdown != 0) {
            return;
        }
        if (this.isCaveLike(blockPos)) {
            if (!BlockPos.m_121919_((BoundingBox)new BoundingBox(blockPos).m_191961_(1)).allMatch(this::isCaveLike)) {
                return;
            }
            AmbientMoodSettings ambientMoodSettings = AmbientMoodSettings.f_47387_;
            double blockX = (double)blockPos.m_123341_() + 0.5;
            double blockY = (double)blockPos.m_123342_() + 0.5;
            double blockZ = (double)blockPos.m_123343_() + 0.5;
            double dx = blockX - this.player.m_20185_();
            double dy = blockY - this.player.m_20188_();
            double dz = blockZ - this.player.m_20189_();
            double normal = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double offset = normal + ambientMoodSettings.m_47409_();
            double x = this.player.m_20185_() + dx / normal * offset;
            double y = this.player.m_20188_() + dy / normal * offset;
            double z = this.player.m_20189_() + dz / normal * offset;
            this.soundManager.m_120367_((SoundInstance)CaveSoundManager.getSound(this.randomSource, x, y, z));
            this.tickCountdown = this.randomSource.m_188503_(12000) + 6000;
        }
    }

    private boolean isCaveLike(BlockPos blockPos) {
        if (this.level.m_8055_(blockPos).m_60734_() instanceof AirBlock) {
            int blockLight = this.level.m_45517_(LightLayer.BLOCK, blockPos);
            int skyLight = this.level.m_45517_(LightLayer.SKY, blockPos);
            return blockLight <= 0 && skyLight <= 0;
        }
        return false;
    }
}

