/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.sound;

import mod.adrenix.nostalgic.client.ClientSound;
import mod.adrenix.nostalgic.tweak.config.SoundTweak;
import mod.adrenix.nostalgic.tweak.enums.MusicType;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.data.NullableHolder;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class MusicHelper {
    public static final NullableHolder<SoundInstance> CURRENT_SONG = NullableHolder.empty();

    private static SoundInstance setAndGet(SoundEvent sound) {
        return CURRENT_SONG.setAndGet((SoundInstance)SimpleSoundInstance.m_119745_((SoundEvent)sound));
    }

    public static SoundInstance apply(SoundInstance sound) {
        ResourceLocation soundLocation = sound.m_7904_();
        if (soundLocation.equals((Object)((SoundEvent)SoundEvents.f_12153_.m_203334_()).m_11660_())) {
            MusicType musicType = (MusicType)SoundTweak.MUSIC_FOR_MENU.get();
            if (musicType == MusicType.MODERN) {
                return sound;
            }
            return MusicHelper.setAndGet(switch (musicType) {
                case MusicType.ALPHA -> (SoundEvent)ClientSound.MUSIC_ALPHA.get();
                case MusicType.BETA -> (SoundEvent)ClientSound.MUSIC_MENU_BETA.get();
                case MusicType.BLENDED -> (SoundEvent)ClientSound.MUSIC_MENU_BLENDED.get();
                default -> (SoundEvent)ClientSound.BLANK.get();
            });
        }
        if (soundLocation.equals((Object)((SoundEvent)SoundEvents.f_12082_.m_203334_()).m_11660_())) {
            MusicType musicType = (MusicType)SoundTweak.MUSIC_FOR_CREATIVE.get();
            if (musicType == MusicType.MODERN) {
                return sound;
            }
            return MusicHelper.setAndGet(switch (musicType) {
                case MusicType.ALPHA -> (SoundEvent)ClientSound.MUSIC_ALPHA.get();
                case MusicType.BETA -> (SoundEvent)ClientSound.MUSIC_CREATIVE_BETA.get();
                case MusicType.BLENDED -> (SoundEvent)ClientSound.MUSIC_CREATIVE_BLENDED.get();
                default -> (SoundEvent)ClientSound.BLANK.get();
            });
        }
        if (((Boolean)SoundTweak.REPLACE_OVERWORLD_BIOME_MUSIC.get()).booleanValue() && GameUtil.isInOverworld()) {
            if (soundLocation.m_135815_().contains("music.overworld")) {
                return MusicHelper.setAndGet((SoundEvent)ClientSound.MUSIC_ALPHA.get());
            }
            if (soundLocation.equals((Object)((SoundEvent)SoundEvents.f_12159_.m_203334_()).m_11660_())) {
                return MusicHelper.setAndGet((SoundEvent)ClientSound.MUSIC_ALPHA.get());
            }
        }
        if (((Boolean)SoundTweak.REPLACE_NETHER_BIOME_MUSIC.get()).booleanValue() && GameUtil.isInNether() && soundLocation.m_135815_().contains("music.nether")) {
            return MusicHelper.setAndGet((SoundEvent)ClientSound.MUSIC_ALPHA.get());
        }
        if (((Boolean)SoundTweak.REPLACE_GAMEPLAY_MUSIC.get()).booleanValue() && soundLocation.equals((Object)((SoundEvent)SoundEvents.f_12152_.m_203334_()).m_11660_())) {
            return MusicHelper.setAndGet((SoundEvent)ClientSound.MUSIC_ALPHA.get());
        }
        return sound;
    }
}

