/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.sound;

import java.util.List;
import mod.adrenix.nostalgic.helper.candy.block.ChestHelper;
import mod.adrenix.nostalgic.helper.sound.PositionSoundHandler;
import mod.adrenix.nostalgic.mixin.access.EntityAccess;
import mod.adrenix.nostalgic.tweak.config.AnimationTweak;
import mod.adrenix.nostalgic.tweak.config.SoundTweak;
import mod.adrenix.nostalgic.tweak.listing.StringSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class SoundHelper {
    public static boolean isEntityStepIgnored(Entity entity) {
        return entity instanceof Spider || entity instanceof Silverfish || entity instanceof Bee;
    }

    public static boolean isModdedStepIgnored(Entity entity) {
        return (Boolean)SoundTweak.IGNORE_MODDED_STEP.get() != false && !entity.m_6095_().m_20675_().contains("minecraft");
    }

    @Nullable
    public static PositionSoundHandler getHandlerAt(ClientLevel level, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch) {
        if (level == null || sound == null) {
            return null;
        }
        PositionSoundHandler handler = PositionSoundHandler.create(level, x, y, z, sound, source, volume, pitch);
        handler.apply(SoundHelper::isDisabledHandled);
        handler.apply(SoundHelper::isFurnaceHandled);
        handler.apply(SoundHelper::isAttackHandled);
        handler.apply(SoundHelper::isGrowthHandled);
        handler.apply(SoundHelper::isRowingHandled);
        handler.apply(SoundHelper::isSquidHandled);
        handler.apply(SoundHelper::isChestHandled);
        handler.apply(SoundHelper::isLavaHandled);
        handler.apply(SoundHelper::isSwimHandled);
        handler.apply(SoundHelper::isFishHandled);
        handler.apply(SoundHelper::isStepHandled);
        handler.apply(SoundHelper::isDoorHandled);
        handler.apply(SoundHelper::isBedHandled);
        handler.apply(SoundHelper::isXpHandled);
        return handler;
    }

    private static boolean isDisabledHandled(PositionSoundHandler handler) {
        if (((StringSet)SoundTweak.DISABLED_POSITIONED_SOUNDS.get()).contains(handler.sound.m_11660_().toString())) {
            return handler.mute(new SoundEvent[0]);
        }
        return false;
    }

    private static boolean isAttackHandled(PositionSoundHandler handler) {
        boolean isAttack;
        if (!((Boolean)SoundTweak.OLD_ATTACK.get()).booleanValue()) {
            return false;
        }
        boolean isCrit = handler.compare(SoundEvents.f_12313_);
        boolean isKnock = handler.compare(SoundEvents.f_12314_);
        boolean isDamage = handler.compare(SoundEvents.f_12315_);
        boolean isStrong = handler.compare(SoundEvents.f_12316_);
        boolean isSweep = handler.compare(SoundEvents.f_12317_);
        boolean isWeak = handler.compare(SoundEvents.f_12318_);
        boolean bl = isAttack = isCrit || isKnock || isDamage || isStrong || isSweep || isWeak;
        if (isAttack) {
            handler.mute(new SoundEvent[0]);
        }
        return isAttack;
    }

    private static boolean isFurnaceHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_FURNACE.get()).booleanValue() && handler.blockState.m_60734_() instanceof FurnaceBlock) {
            return handler.mute(SoundEvents.f_11907_);
        }
        if (((Boolean)SoundTweak.DISABLE_BLAST_FURNACE.get()).booleanValue() && handler.blockState.m_60734_() instanceof BlastFurnaceBlock) {
            return handler.mute(SoundEvents.f_11715_);
        }
        return false;
    }

    private static boolean isGrowthHandled(PositionSoundHandler handler) {
        return (Boolean)SoundTweak.DISABLE_GROWTH.get() != false && handler.mute(SoundEvents.f_144074_);
    }

    private static boolean isRowingHandled(PositionSoundHandler handler) {
        if (!((Boolean)AnimationTweak.HIDE_BOAT_ROWING.get()).booleanValue() || !handler.compare(SoundEvents.f_11707_, SoundEvents.f_11706_)) {
            return false;
        }
        List boats = handler.level.m_45976_(Boat.class, new AABB(handler.blockPos).m_82400_(3.0));
        if (boats.isEmpty()) {
            return false;
        }
        handler.mute(SoundEvents.f_11707_, SoundEvents.f_11706_);
        return true;
    }

    private static boolean isSquidHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_SQUID.get()).booleanValue() && handler.mute(SoundEvents.f_12438_, SoundEvents.f_12439_, SoundEvents.f_12440_, SoundEvents.f_12441_)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_GLOW_SQUID_OTHER.get()).booleanValue() && handler.mute(SoundEvents.f_144160_, SoundEvents.f_144161_, SoundEvents.f_144162_)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_GLOW_SQUID_AMBIENCE.get()).booleanValue()) {
            return handler.mute(SoundEvents.f_144159_);
        }
        return false;
    }

    private static boolean isLavaHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_LAVA_AMBIENCE.get()).booleanValue() && handler.mute(SoundEvents.f_12030_)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_LAVA_POP.get()).booleanValue()) {
            return handler.mute(SoundEvents.f_12032_);
        }
        return false;
    }

    private static boolean isSwimHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_GENERIC_SWIM.get()).booleanValue()) {
            return handler.mute(SoundEvents.f_11918_, SoundEvents.f_12279_);
        }
        return false;
    }

    private static boolean isFishHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_FISH_SWIM.get()).booleanValue() && handler.mute(SoundEvents.f_11938_)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_FISH_HURT.get()).booleanValue() && handler.mute(SoundEvents.f_11761_, SoundEvents.f_12294_, SoundEvents.f_12330_, SoundEvents.f_215761_, SoundEvents.f_12529_)) {
            return true;
        }
        if (((Boolean)SoundTweak.DISABLE_FISH_DEATH.get()).booleanValue()) {
            return handler.mute(SoundEvents.f_11759_, SoundEvents.f_12292_, SoundEvents.f_12328_, SoundEvents.f_215758_, SoundEvents.f_12527_);
        }
        return false;
    }

    private static boolean isDoorHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_DOOR_PLACE.get()).booleanValue() && handler.blockState.m_60734_() instanceof DoorBlock && handler.sound == handler.blockState.m_60827_().m_56777_()) {
            return handler.mute(new SoundEvent[0]);
        }
        return false;
    }

    private static boolean isBedHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_BED_PLACE.get()).booleanValue() && handler.blockState.m_60734_() instanceof BedBlock && handler.sound == handler.blockState.m_60827_().m_56777_()) {
            return handler.mute(new SoundEvent[0]);
        }
        return false;
    }

    private static boolean isChestHandled(PositionSoundHandler handler) {
        boolean isChestSound;
        boolean isOpenSound = handler.compare(SoundEvents.f_11749_, SoundEvents.f_11889_);
        boolean isCloseSound = handler.compare(SoundEvents.f_11747_, SoundEvents.f_11888_);
        boolean bl = isChestSound = isOpenSound || isCloseSound;
        if (!isChestSound) {
            return false;
        }
        if (((Boolean)SoundTweak.DISABLE_CHEST.get()).booleanValue() && ChestHelper.isOld(handler.blockState)) {
            handler.mute(new SoundEvent[0]);
        }
        if (((Boolean)SoundTweak.OLD_CHEST.get()).booleanValue()) {
            handler.sound = SoundEvents.f_12627_;
            if (handler.compare(SoundEvents.f_11747_, SoundEvents.f_11888_)) {
                handler.sound = SoundEvents.f_12626_;
            }
            handler.pitch = handler.randomSource().m_188501_() * 0.1f + 0.9f;
        }
        return true;
    }

    private static boolean isXpHandled(PositionSoundHandler handler) {
        if (((Boolean)SoundTweak.DISABLE_XP_PICKUP.get()).booleanValue()) {
            return handler.mute(SoundEvents.f_11871_);
        }
        if (((Boolean)SoundTweak.OLD_XP.get()).booleanValue() && handler.compare(SoundEvents.f_11871_)) {
            handler.sound = SoundEvents.f_12019_;
            handler.pitch = handler.randomSource().m_188501_() - handler.randomSource().m_188501_() * 0.1f + 0.01f;
            return true;
        }
        return false;
    }

    private static boolean isStepHandled(PositionSoundHandler handler) {
        String path = handler.sound.m_11660_().m_135815_();
        boolean isEntityStep = path.contains("entity.") && path.contains(".step");
        boolean isSingleplayer = Minecraft.m_91087_().m_91091_();
        if (!((Boolean)SoundTweak.OLD_STEP.get()).booleanValue() || !isEntityStep || isSingleplayer) {
            return false;
        }
        List entities = handler.level.m_45976_(LivingEntity.class, new AABB(handler.blockPos).m_82400_(3.0));
        if (entities.isEmpty()) {
            return false;
        }
        BlockState standingOn = handler.level.m_8055_(handler.blockPos.m_7495_());
        LivingEntity entity = (LivingEntity)entities.get(0);
        if (SoundHelper.isEntityStepIgnored((Entity)entity) || standingOn.m_60795_()) {
            return handler.mute(new SoundEvent[0]);
        }
        if (SoundHelper.isModdedStepIgnored((Entity)entity) || !standingOn.m_60819_().m_76178_()) {
            return false;
        }
        SoundType soundType = handler.getSoundTypeAt(((EntityAccess)entity).nt$getPrimaryStepSoundBlockPos(handler.blockPos.m_7495_()));
        handler.source = entity.m_5720_();
        handler.volume = soundType.m_56773_() * 0.15f;
        handler.sound = soundType.m_56776_();
        handler.pitch = soundType.m_56774_();
        return true;
    }
}

