/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.helper.swing;

import mod.adrenix.nostalgic.helper.animation.PlayerArmHelper;
import mod.adrenix.nostalgic.helper.swing.SwingType;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.config.SwingTweak;
import mod.adrenix.nostalgic.tweak.listing.ItemMap;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;

public abstract class SwingHelper {
    public static boolean isSpeedGlobal() {
        return switch (PlayerArmHelper.SWING_TYPE.get()) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.ATTACK -> {
                if ((Integer)SwingTweak.ATTACK_GLOBAL_SPEED.get() != -1) {
                    yield true;
                }
                yield false;
            }
            case SwingType.USE -> (Integer)SwingTweak.USE_GLOBAL_SPEED.get() != -1;
        };
    }

    public static int getGlobalSpeed() {
        return switch (PlayerArmHelper.SWING_TYPE.get()) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.ATTACK -> (Integer)SwingTweak.ATTACK_GLOBAL_SPEED.get();
            case SwingType.USE -> (Integer)SwingTweak.USE_GLOBAL_SPEED.get();
        };
    }

    public static int getSpeedFromItem(Item item) {
        boolean containsItem;
        SwingType swingType = PlayerArmHelper.SWING_TYPE.get();
        switch (swingType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ATTACK: {
                boolean bl = ((ItemMap)SwingTweak.ATTACK_SWING_SPEEDS.get()).containsItem(item);
                break;
            }
            case USE: {
                boolean bl = containsItem = ((ItemMap)SwingTweak.USE_SWING_SPEEDS.get()).containsItem(item);
            }
        }
        if (SwingHelper.isSpeedGlobal()) {
            return switch (swingType) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.ATTACK -> (Integer)SwingTweak.ATTACK_GLOBAL_SPEED.get();
                case SwingType.USE -> (Integer)SwingTweak.USE_GLOBAL_SPEED.get();
            };
        }
        if (containsItem) {
            return switch (swingType) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.ATTACK -> (Integer)((ItemMap)SwingTweak.ATTACK_SWING_SPEEDS.get()).valueFrom(item);
                case SwingType.USE -> (Integer)((ItemMap)SwingTweak.USE_SWING_SPEEDS.get()).valueFrom(item);
            };
        }
        if (item instanceof SwordItem) {
            return switch (swingType) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.ATTACK -> (Integer)SwingTweak.ATTACK_SWORD_SPEED.get();
                case SwingType.USE -> (Integer)SwingTweak.USE_SWORD_SPEED.get();
            };
        }
        if (item instanceof BlockItem) {
            return switch (swingType) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.ATTACK -> (Integer)SwingTweak.ATTACK_BLOCK_SPEED.get();
                case SwingType.USE -> (Integer)SwingTweak.USE_BLOCK_SPEED.get();
            };
        }
        if (item instanceof DiggerItem) {
            return switch (swingType) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.ATTACK -> (Integer)SwingTweak.ATTACK_TOOL_SPEED.get();
                case SwingType.USE -> (Integer)SwingTweak.USE_TOOL_SPEED.get();
            };
        }
        return switch (swingType) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.ATTACK -> (Integer)SwingTweak.ATTACK_ITEM_SPEED.get();
            case SwingType.USE -> (Integer)SwingTweak.USE_ITEM_SPEED.get();
        };
    }

    public static int getSwingSpeed(AbstractClientPlayer player) {
        if (((Boolean)ModTweak.ENABLED.get()).booleanValue()) {
            return SwingHelper.getSpeedFromItem(player.m_21205_().m_41720_());
        }
        return 6;
    }

    public static boolean isFatigueOverride() {
        boolean bl;
        block6: {
            block5: {
                if (!((Boolean)ModTweak.ENABLED.get()).booleanValue()) break block5;
                switch (PlayerArmHelper.SWING_TYPE.get()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ATTACK: {
                        if ((Integer)SwingTweak.ATTACK_FATIGUE_SPEED.get() != -1) {
                            break;
                        }
                        break block5;
                    }
                    case USE: {
                        if ((Integer)SwingTweak.USE_FATIGUE_SPEED.get() == -1) break block5;
                    }
                }
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static int getFatigueSpeed() {
        int n;
        if (SwingHelper.isSpeedGlobal()) {
            n = SwingHelper.getGlobalSpeed();
        } else {
            n = switch (PlayerArmHelper.SWING_TYPE.get()) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.ATTACK -> (Integer)SwingTweak.ATTACK_FATIGUE_SPEED.get();
                case SwingType.USE -> (Integer)SwingTweak.USE_FATIGUE_SPEED.get();
            };
        }
        return n;
    }

    public static boolean isHasteOverride() {
        boolean bl;
        block6: {
            block5: {
                if (!((Boolean)ModTweak.ENABLED.get()).booleanValue()) break block5;
                switch (PlayerArmHelper.SWING_TYPE.get()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ATTACK: {
                        if ((Integer)SwingTweak.ATTACK_HASTE_SPEED.get() != -1) {
                            break;
                        }
                        break block5;
                    }
                    case USE: {
                        if ((Integer)SwingTweak.USE_HASTE_SPEED.get() == -1) break block5;
                    }
                }
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static int getHasteSpeed() {
        int n;
        if (SwingHelper.isSpeedGlobal()) {
            n = SwingHelper.getGlobalSpeed();
        } else {
            n = switch (PlayerArmHelper.SWING_TYPE.get()) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.ATTACK -> (Integer)SwingTweak.ATTACK_HASTE_SPEED.get();
                case SwingType.USE -> (Integer)SwingTweak.USE_HASTE_SPEED.get();
            };
        }
        return n;
    }
}

