/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.listener.common;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.helper.gameplay.combat.SwordBlockingHelper;
import mod.adrenix.nostalgic.mixin.access.AxeItemAccess;
import mod.adrenix.nostalgic.mixin.access.ShovelItemAccess;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.util.common.world.PlayerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class InteractionListener {
    public static void register() {
        InteractionEvent.RIGHT_CLICK_ITEM.register(InteractionListener::onRightClickItem);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(InteractionListener::onRightClickBlock);
        InteractionEvent.LEFT_CLICK_BLOCK.register(InteractionListener::onLeftClickBlock);
        InteractionEvent.INTERACT_ENTITY.register(InteractionListener::onInteractEntity);
    }

    private static CompoundEventResult<ItemStack> onRightClickItem(Player player, InteractionHand hand) {
        ItemStack itemStackInHand = player.m_21120_(hand);
        Item itemInHand = itemStackInHand.m_41720_();
        if (((Boolean)GameplayTweak.INSTANT_BOW.get()).booleanValue() && itemInHand.equals(Items.f_42411_) && itemInHand instanceof BowItem) {
            BowItem bow = (BowItem)itemInHand;
            int timeCharged = 72000 - (int)((float)((Integer)GameplayTweak.ARROW_SPEED.get()).intValue() / 100.0f * 20.0f);
            bow.m_5551_(itemStackInHand, player.m_9236_(), (LivingEntity)player, timeCharged);
            return CompoundEventResult.interruptTrue((Object)itemStackInHand);
        }
        if (SwordBlockingHelper.canBlock(player) && !player.m_6117_()) {
            player.m_6672_(hand);
            return CompoundEventResult.interruptTrue((Object)itemStackInHand);
        }
        return CompoundEventResult.pass();
    }

    private static EventResult onRightClickBlock(Player player, InteractionHand hand, BlockPos blockPos, Direction face) {
        Level level = player.m_9236_();
        RandomSource randomSource = level.m_213780_();
        BlockState blockState = level.m_8055_(blockPos);
        BlockState aboveState = level.m_8055_(blockPos.m_7494_());
        Item itemInHand = player.m_21120_(hand).m_41720_();
        if (((Boolean)GameplayTweak.DISABLE_ANVIL.get()).booleanValue() && blockState.m_204336_(BlockTags.f_13033_)) {
            return EventResult.interruptTrue();
        }
        if (((Boolean)GameplayTweak.DISABLE_ENCHANT_TABLE.get()).booleanValue() && blockState.m_60713_(Blocks.f_50201_)) {
            return EventResult.interruptTrue();
        }
        if (((Boolean)GameplayTweak.TILLED_GRASS_SEEDS.get()).booleanValue() && blockState.m_60713_(Blocks.f_50440_) && itemInHand instanceof HoeItem) {
            if (!aboveState.m_60795_() || randomSource.m_188503_(10) != 0) {
                return EventResult.pass();
            }
            double x = (double)blockPos.m_123341_() + 0.5 + Mth.m_216263_((RandomSource)randomSource, (double)-0.05, (double)0.05);
            double y = (double)blockPos.m_123342_() + 1.0;
            double z = (double)blockPos.m_123343_() + 0.5 + Mth.m_216263_((RandomSource)randomSource, (double)-0.05, (double)0.05);
            double dx = Mth.m_216263_((RandomSource)randomSource, (double)-0.1, (double)0.1);
            double dy = Mth.m_216263_((RandomSource)randomSource, (double)0.18, (double)0.2);
            double dz = Mth.m_216263_((RandomSource)randomSource, (double)-0.1, (double)0.1);
            ItemEntity seedEntity = new ItemEntity(level, x, y, z, new ItemStack((ItemLike)Items.f_42404_), dx, dy, dz);
            seedEntity.m_32060_();
            level.m_7967_((Entity)seedEntity);
        }
        if (NostalgicTweaks.isServer()) {
            if (((Boolean)GameplayTweak.DISABLE_SHOVEL_PATHING.get()).booleanValue() && itemInHand instanceof ShovelItem && ShovelItemAccess.NT$FLATTENABLES().containsKey(blockState.m_60734_())) {
                return EventResult.interruptTrue();
            }
            if (((Boolean)GameplayTweak.DISABLE_AXE_STRIPPING.get()).booleanValue() && itemInHand instanceof AxeItem && AxeItemAccess.NT$STRIPPABLES().containsKey(blockState.m_60734_())) {
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }

    private static EventResult onLeftClickBlock(Player player, InteractionHand hand, BlockPos blockPos, Direction face) {
        Level level = player.m_20193_();
        BlockHitResult blockHitResult = new BlockHitResult(Vec3.m_82512_((Vec3i)blockPos), face, blockPos, false);
        BlockState blockState = level.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (((Boolean)GameplayTweak.PUNCH_TNT_IGNITION.get()).booleanValue() && !player.m_6047_() && block instanceof TntBlock) {
            TntBlock.m_57433_((Level)level, (BlockPos)blockPos);
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 11);
            return EventResult.interruptTrue();
        }
        if (player.f_20911_) {
            return EventResult.pass();
        }
        if (((Boolean)GameplayTweak.LEFT_CLICK_DOOR.get()).booleanValue() && PlayerUtil.isSurvival(player) && (block instanceof DoorBlock || block instanceof TrapDoorBlock || block instanceof FenceGateBlock)) {
            blockState.m_60664_(level, player, hand, blockHitResult);
        }
        if (((Boolean)GameplayTweak.LEFT_CLICK_LEVER.get()).booleanValue() && PlayerUtil.isSurvival(player) && block instanceof LeverBlock) {
            blockState.m_60664_(level, player, hand, blockHitResult);
        }
        if (((Boolean)GameplayTweak.LEFT_CLICK_BUTTON.get()).booleanValue() && PlayerUtil.isSurvival(player) && block instanceof ButtonBlock) {
            blockState.m_60664_(level, player, hand, blockHitResult);
        }
        return EventResult.pass();
    }

    private static EventResult onInteractEntity(Player player, Entity entity, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (((Boolean)GameplayTweak.OLD_SQUID_MILKING.get()).booleanValue() && itemInHand.m_150930_(Items.f_42446_) && entity instanceof Squid) {
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)itemInHand, (Player)player, (ItemStack)Items.f_42455_.m_7968_()));
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }
}

