/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.listener.common;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaHelper;
import mod.adrenix.nostalgic.network.packet.sync.ClientboundHandshake;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.enums.Hotbar;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public abstract class PlayerListener {
    public static void register() {
        PlayerEvent.PLAYER_JOIN.register(PlayerListener::onPlayerJoin);
        PlayerEvent.PLAYER_QUIT.register(PlayerListener::onPlayerQuit);
        TickEvent.PLAYER_POST.register(PlayerListener::onTick);
    }

    public static void onTick(Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        if (((Boolean)GameplayTweak.DISABLE_SPRINT.get()).booleanValue() && player.m_20142_()) {
            player.m_6858_(false);
        }
        if (((Boolean)GameplayTweak.DISABLE_SWIM.get()).booleanValue() && player.m_6069_()) {
            player.m_20282_(false);
        }
        StaminaHelper.tick(player);
        if (StaminaHelper.get(player).isExhausted()) {
            if (player.m_20142_()) {
                player.m_6858_(false);
            }
            if (player.m_6069_()) {
                player.m_20282_(false);
            }
        }
    }

    private static void onPlayerJoin(ServerPlayer player) {
        String loader = NostalgicTweaks.getLoader();
        String tiny = NostalgicTweaks.getTinyVersion();
        String beta = NostalgicTweaks.getBetaVersion();
        String version = beta.isEmpty() ? tiny : tiny + "-" + beta;
        String protocol = NostalgicTweaks.getProtocol();
        NostalgicTweaks.NETWORK.sendToPlayer(player, (Object)new ClientboundHandshake(loader, version, protocol));
        PlayerListener.setCreativeHotbar(player);
    }

    private static void onPlayerQuit(ServerPlayer player) {
        StaminaHelper.remove((Player)player);
    }

    private static void setBlockInSlot(ServerPlayer player, int slot, Block block) {
        player.m_150109_().m_36040_(slot, block.m_5456_().m_7968_());
    }

    private static void setCreativeHotbar(ServerPlayer player) {
        boolean isNostalgic;
        Hotbar hotbar = (Hotbar)CandyTweak.OLD_CREATIVE_HOTBAR.get();
        boolean isCreative = player.f_8941_.m_9290_() == GameType.CREATIVE;
        boolean bl = isNostalgic = hotbar != Hotbar.MODERN;
        if (player.m_150109_().m_7983_() && isCreative && isNostalgic) {
            PlayerListener.setBlockInSlot(player, 0, Blocks.f_50069_);
            PlayerListener.setBlockInSlot(player, 1, Blocks.f_50652_);
            PlayerListener.setBlockInSlot(player, 2, Blocks.f_50076_);
            PlayerListener.setBlockInSlot(player, 3, Blocks.f_50493_);
            PlayerListener.setBlockInSlot(player, 4, Blocks.f_50705_);
            PlayerListener.setBlockInSlot(player, 5, Blocks.f_49999_);
            PlayerListener.setBlockInSlot(player, 6, Blocks.f_50050_);
            PlayerListener.setBlockInSlot(player, 8, Blocks.f_50405_);
            if (hotbar == Hotbar.BETA) {
                PlayerListener.setBlockInSlot(player, 7, Blocks.f_50081_);
            } else {
                PlayerListener.setBlockInSlot(player, 7, Blocks.f_50058_);
            }
        }
    }
}

