/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.candy.chest_block;

import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.common.CalendarUtil;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @ModifyArg(method={"loadModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/resources/FileToIdConverter;idToFile(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation nt_chest_block$modifyBlockStateLocation(ResourceLocation resourceLocation) {
        String minecraft = "minecraft";
        String namespace = resourceLocation.m_135827_();
        String path = resourceLocation.m_135815_();
        if (!namespace.equals(minecraft)) {
            return resourceLocation;
        }
        switch (path) {
            case "chest": {
                String string;
                if (((Boolean)CandyTweak.OLD_CHEST.get()).booleanValue()) {
                    string = "nostalgic_tweaks";
                    break;
                }
                string = minecraft;
                break;
            }
            case "ender_chest": {
                String string;
                if (((Boolean)CandyTweak.OLD_ENDER_CHEST.get()).booleanValue()) {
                    string = "nostalgic_tweaks";
                    break;
                }
                string = minecraft;
                break;
            }
            case "trapped_chest": {
                String string;
                if (((Boolean)CandyTweak.OLD_TRAPPED_CHEST.get()).booleanValue()) {
                    string = "nostalgic_tweaks";
                    break;
                }
                string = minecraft;
                break;
            }
            default: {
                String string = namespace = namespace;
            }
        }
        if (namespace.equals(minecraft)) {
            return resourceLocation;
        }
        if (CalendarUtil.isChristmasTime() && path.equals("chest")) {
            return new ResourceLocation(namespace, "christmas_chest");
        }
        return new ResourceLocation(namespace, path);
    }

    @ModifyVariable(method={"loadBlockModel"}, argsOnly=true, ordinal=0, at=@At(value="HEAD"))
    private ResourceLocation nt_chest_block$modifyBlockModelLocation(ResourceLocation resourceLocation) {
        String minecraft = "minecraft";
        String namespace = resourceLocation.m_135827_();
        String path = resourceLocation.m_135815_();
        String modId = "nostalgic_tweaks";
        boolean isOldChest = (Boolean)CandyTweak.OLD_CHEST.get();
        boolean isOldEnderChest = (Boolean)CandyTweak.OLD_ENDER_CHEST.get();
        boolean isOldTrappedChest = (Boolean)CandyTweak.OLD_TRAPPED_CHEST.get();
        if (!namespace.equals(minecraft)) {
            return resourceLocation;
        }
        switch (path) {
            case "block/chest": 
            case "item/chest": {
                String string;
                if (isOldChest) {
                    string = modId;
                    break;
                }
                string = minecraft;
                break;
            }
            case "block/ender_chest": 
            case "item/ender_chest": {
                String string;
                if (isOldEnderChest) {
                    string = modId;
                    break;
                }
                string = minecraft;
                break;
            }
            case "block/trapped_chest": 
            case "item/trapped_chest": {
                String string;
                if (isOldTrappedChest) {
                    string = modId;
                    break;
                }
                string = minecraft;
                break;
            }
            default: {
                String string = namespace = namespace;
            }
        }
        if (isOldChest && !isOldEnderChest && path.equals("item/ender_chest")) {
            return new ResourceLocation("nostalgic_tweaks", "item/vanilla_ender_chest");
        }
        if (isOldChest && !isOldTrappedChest && path.equals("item/trapped_chest")) {
            return new ResourceLocation("nostalgic_tweaks", "item/vanilla_trapped_chest");
        }
        if (isOldChest && CalendarUtil.isChristmasTime()) {
            if (path.equals("block/chest")) {
                return new ResourceLocation(namespace, "block/christmas_chest");
            }
            if (path.equals("item/chest")) {
                return new ResourceLocation(namespace, "item/christmas_chest");
            }
        }
        return new ResourceLocation(namespace, path);
    }
}

