/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.candy.world_lighting;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.adrenix.nostalgic.helper.candy.light.LightingHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.common.data.NullableAction;
import mod.adrenix.nostalgic.util.common.data.Pair;
import net.minecraft.client.Camera;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel f_109465_;
    @Shadow
    @Nullable
    private ViewArea f_109469_;

    @Shadow
    public abstract boolean m_202430_(BlockPos var1);

    @Shadow
    protected abstract void m_109501_(int var1, int var2, int var3, boolean var4);

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void nt_world_lighting$onRenderLevel(PoseStack poseStack, float partialTick, long finishNanoTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f projectionMatrix, CallbackInfo callback) {
        if (!((Boolean)ModTweak.ENABLED.get()).booleanValue() || this.f_109465_ == null) {
            return;
        }
        if (!LightingHelper.PACKED_RELIGHT_QUEUE.isEmpty()) {
            Pair<Long, Byte> packedRelight = LightingHelper.PACKED_RELIGHT_QUEUE.pop();
            ChunkPos chunkPos = new ChunkPos(packedRelight.left().longValue());
            LevelChunk chunk = this.f_109465_.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
            if (chunk != null) {
                LightingHelper.relightChunk(chunk, packedRelight.right());
            } else if (this.m_202430_(chunkPos.m_45615_())) {
                LightingHelper.PACKED_RELIGHT_QUEUE.add(packedRelight);
            }
        }
        for (int i = 0; i < 4096 && !LightingHelper.PACKED_CHUNK_BLOCK_QUEUE.isEmpty(); ++i) {
            Pair<Long, Long> packedQueue = LightingHelper.PACKED_CHUNK_BLOCK_QUEUE.pop();
            ChunkPos chunkPos = new ChunkPos(packedQueue.left().longValue());
            LevelChunk chunk = this.f_109465_.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
            if (chunk != null) {
                BlockPos blockPos = BlockPos.m_122022_((long)packedQueue.right());
                int x = blockPos.m_123341_() & 0xF;
                int y = blockPos.m_123342_() & 0xF;
                int z = blockPos.m_123343_() & 0xF;
                NullableAction.attempt(chunk.m_284400_(), skyLightSources -> skyLightSources.m_284521_((BlockGetter)chunk, x, y, z));
                chunk.m_62953_().m_5518_().m_7174_(blockPos);
                continue;
            }
            if (!this.m_202430_(chunkPos.m_45615_())) continue;
            LightingHelper.PACKED_CHUNK_BLOCK_QUEUE.add(packedQueue);
        }
    }

    @Inject(method={"allChanged"}, at={@At(value="HEAD")})
    private void nt_world_lighting$onAllChanged(CallbackInfo callback) {
        if (!((Boolean)LightingHelper.RELIGHT_ALL_CHUNKS.get()).booleanValue() || ModTracker.SODIUM.isInstalled() || this.f_109465_ == null || this.f_109469_ == null) {
            return;
        }
        for (ChunkRenderDispatcher.RenderChunk renderChunk : this.f_109469_.f_110843_) {
            if (renderChunk.m_112835_().m_112757_()) continue;
            long packedPos = SectionPos.m_123199_((BlockPos)renderChunk.m_112839_()).m_123251_().m_45588_();
            LightingHelper.PACKED_RELIGHT_QUEUE.add(new Pair<Long, Byte>(packedPos, (byte)1));
        }
        LightingHelper.RELIGHT_ALL_CHUNKS.disable();
    }

    @Inject(method={"compileChunks"}, at={@At(value="HEAD")})
    private void nt_world_lighting$onCompileSections(Camera camera, CallbackInfo callback) {
        boolean isRelightNeeded;
        boolean bl = isRelightNeeded = (Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get() != false && LightingHelper.isRelightCheckEnqueued();
        if (!isRelightNeeded || this.f_109469_ == null || ModTracker.SODIUM.isInstalled()) {
            return;
        }
        for (ChunkRenderDispatcher.RenderChunk renderChunk : this.f_109469_.f_110843_) {
            SectionPos sectionPos = SectionPos.m_123199_((BlockPos)renderChunk.m_112839_());
            this.m_109501_(sectionPos.m_123170_(), sectionPos.m_123206_(), sectionPos.m_123222_(), true);
        }
    }

    @ModifyExpressionValue(method={"compileChunks"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;")})
    private <T> T nt_world_lighting$onGetCompilePriority(T chunkPriority) {
        if (ModTracker.SODIUM.isInstalled()) {
            return chunkPriority;
        }
        return (T)((Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get() != false && LightingHelper.isRelightCheckEnqueued() ? PrioritizeChunkUpdates.NONE : chunkPriority);
    }

    @Inject(method={"compileChunks"}, at={@At(value="RETURN")})
    private void nt_world_lighting$onFinishCompileSections(Camera camera, CallbackInfo callback) {
        if (LightingHelper.isRelightCheckEnqueued() && !ModTracker.SODIUM.isInstalled()) {
            LightingHelper.setRelightingAsFinished();
        }
    }
}

