/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;

public interface ModPacket {
    public static <T extends ModPacket> void register(Class<T> classType, Function<FriendlyByteBuf, T> decoder) {
        NostalgicTweaks.NETWORK.register(classType, ModPacket::encode, decoder, ModPacket::handle);
    }

    public void encode(FriendlyByteBuf var1);

    public void apply(NetworkManager.PacketContext var1);

    default public void handle(Supplier<NetworkManager.PacketContext> supplier) {
        supplier.get().queue(() -> this.apply((NetworkManager.PacketContext)supplier.get()));
    }

    default public ServerPlayer getServerPlayer(NetworkManager.PacketContext context) {
        return (ServerPlayer)context.getPlayer();
    }

    default public String getPlayerName(NetworkManager.PacketContext context) {
        Component name = context.getPlayer().m_5446_();
        if (name == null) {
            return "null";
        }
        return name.getString();
    }

    default public boolean isNotFromOperator(NetworkManager.PacketContext context) {
        if (this.isClientHandling(context)) {
            return true;
        }
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String playerName = this.getPlayerName(context);
        if (PacketUtil.isPlayerOp(player)) {
            return false;
        }
        NostalgicTweaks.LOGGER.warn("Player (%s) tried changing server data without permission", playerName);
        return true;
    }

    default public void log(String message, Object ... args) {
        if (NostalgicTweaks.isServer() && ((Boolean)ModTweak.SERVER_LOGGING.get()).booleanValue()) {
            NostalgicTweaks.LOGGER.info(message, args);
        }
    }

    default public boolean isEnvHandling(NetworkManager.PacketContext context, Dist envType) {
        if (context.getEnv() == envType) {
            PacketUtil.warn(envType, this.getClass());
            return true;
        }
        return false;
    }

    default public boolean isClientHandling(NetworkManager.PacketContext context) {
        return this.isEnvHandling(context, Dist.CLIENT);
    }

    default public boolean isServerHandling(NetworkManager.PacketContext context) {
        return this.isEnvHandling(context, Dist.DEDICATED_SERVER);
    }
}

