/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import dev.architectury.networking.NetworkManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.network.packet.backup.DownloadType;
import mod.adrenix.nostalgic.network.packet.backup.ExecuteOnClient;
import net.minecraft.network.FriendlyByteBuf;

public class ClientboundBackupDownload
implements ModPacket {
    final DownloadType downloadType;
    final Set<String> chunks;
    final String filename;
    final boolean isError;

    public ClientboundBackupDownload(BackupObject backup, DownloadType downloadType) {
        this.chunks = new LinkedHashSet<String>();
        this.filename = backup.getFilename();
        this.downloadType = downloadType;
        Path path = backup.getPath();
        boolean isError = false;
        if (Files.exists(path, new LinkOption[0])) {
            try {
                String content = new String(Files.readAllBytes(path));
                Splitter splitter = Splitter.fixedLength((int)Short.MAX_VALUE);
                this.chunks.addAll(splitter.splitToList((CharSequence)content));
            }
            catch (IOException exception) {
                isError = true;
                NostalgicTweaks.LOGGER.error("[I/O Error] Could not read backup file (%s)\n%s", this.filename, exception);
            }
        } else {
            isError = true;
            NostalgicTweaks.LOGGER.error("[I/O Error] Could not found backup file (%s)", this.filename);
        }
        this.isError = isError;
    }

    public ClientboundBackupDownload(FriendlyByteBuf buffer) {
        this.downloadType = (DownloadType)buffer.m_130066_(DownloadType.class);
        this.filename = buffer.m_130277_();
        this.isError = buffer.readBoolean();
        this.chunks = (Set)buffer.m_236838_(Sets::newLinkedHashSetWithExpectedSize, FriendlyByteBuf::m_130277_);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.downloadType);
        buffer.m_130070_(this.filename);
        buffer.writeBoolean(this.isError);
        buffer.m_236828_(this.chunks, FriendlyByteBuf::m_130070_);
    }

    @Override
    public void apply(NetworkManager.PacketContext context) {
        if (this.isServerHandling(context)) {
            return;
        }
        ExecuteOnClient.handleBackupDownload(this);
    }
}

