/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import com.google.common.collect.Sets;
import dev.architectury.networking.NetworkManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.network.packet.backup.ExecuteOnClient;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import net.minecraft.network.FriendlyByteBuf;

public class ClientboundBackupObjects
implements ModPacket {
    final Set<BackupObject> backups;
    final boolean isError;

    public ClientboundBackupObjects() {
        this.backups = new LinkedHashSet<BackupObject>();
        boolean isException = false;
        try {
            List<Path> files = PathUtil.getNewestModified(PathUtil.getBackupPath(), PathUtil::isJsonFile);
            for (Path path : files) {
                this.backups.add(BackupObject.create(path));
            }
        }
        catch (IOException exception) {
            isException = true;
            NostalgicTweaks.LOGGER.error("An error occurred when preparing the server's backup files\n%s", exception);
        }
        this.isError = isException;
    }

    public ClientboundBackupObjects(FriendlyByteBuf buffer) {
        this.isError = buffer.readBoolean();
        this.backups = (Set)buffer.m_236838_(Sets::newLinkedHashSetWithExpectedSize, BackupObject::decode);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isError);
        buffer.m_236828_(this.backups, BackupObject::encode);
    }

    @Override
    public void apply(NetworkManager.PacketContext context) {
        if (this.isServerHandling(context)) {
            return;
        }
        ExecuteOnClient.handleBackupObjects(this);
    }
}

