/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import dev.architectury.networking.NetworkManager;
import java.nio.file.Path;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.ServerConfig;
import mod.adrenix.nostalgic.config.factory.ConfigBuilder;
import mod.adrenix.nostalgic.config.factory.ConfigHandler;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.network.packet.backup.ClientboundAppliedBackup;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;

public class ServerboundApplyBackup
implements ModPacket {
    private final BackupObject backup;

    public ServerboundApplyBackup(BackupObject backup) {
        this.backup = backup;
    }

    public ServerboundApplyBackup(FriendlyByteBuf buffer) {
        this.backup = BackupObject.decode(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        BackupObject.encode(buffer, this.backup);
    }

    @Override
    public void apply(NetworkManager.PacketContext context) {
        if (this.isNotFromOperator(context)) {
            return;
        }
        Path path = this.backup.getPath();
        String filename = path.getFileName().toString();
        ConfigHandler<ServerConfig> imported = ConfigBuilder.temp(ServerConfig.class, path);
        this.log("Player (%s) requested to apply config backup (%s)", this.getPlayerName(context), filename);
        if (imported.load()) {
            ConfigHandler<ServerConfig> handler = ConfigBuilder.getHandler();
            ConfigBuilder.getHandler().backup();
            handler.setLoaded(imported.getLoaded());
            handler.save();
            NostalgicTweaks.LOGGER.info("[Config Import] Imported a new server config using backup (%s)", filename);
            PacketUtil.sendToPlayer(this.getServerPlayer(context), new ClientboundAppliedBackup(true));
            TweakPool.filter(Tweak::isMultiplayerLike).forEach(TweakMeta::sendToAll);
        } else {
            NostalgicTweaks.LOGGER.error("[Config Import] Could not import (%s) due to an invalid config format", filename);
            PacketUtil.sendToPlayer(this.getServerPlayer(context), new ClientboundAppliedBackup(false));
        }
    }
}

