/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import dev.architectury.networking.NetworkManager;
import java.io.IOException;
import java.nio.file.Path;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.network.packet.backup.ClientboundBackupDeleted;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;

public class ServerboundDeleteBackup
implements ModPacket {
    private final BackupObject backup;

    public ServerboundDeleteBackup(BackupObject backup) {
        this.backup = backup;
    }

    public ServerboundDeleteBackup(FriendlyByteBuf buffer) {
        this.backup = BackupObject.decode(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        BackupObject.encode(buffer, this.backup);
    }

    @Override
    public void apply(NetworkManager.PacketContext context) {
        if (this.isNotFromOperator(context)) {
            return;
        }
        Path path = this.backup.getPath();
        String filename = path.getFileName().toString();
        NostalgicTweaks.LOGGER.info("Player (%s) deleted backup (%s)", this.getPlayerName(context), filename);
        try {
            PathUtil.deleteWithoutCatch(path);
            PacketUtil.sendToPlayer(this.getServerPlayer(context), new ClientboundBackupDeleted(true));
        }
        catch (IOException exception) {
            PacketUtil.sendToPlayer(this.getServerPlayer(context), new ClientboundBackupDeleted(false));
        }
    }
}

