/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import dev.architectury.networking.NetworkManager;
import java.nio.file.Path;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.network.packet.backup.ClientboundBackupDownload;
import mod.adrenix.nostalgic.network.packet.backup.DownloadType;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;

public class ServerboundDownloadRequest
implements ModPacket {
    private final BackupObject backup;
    private final DownloadType downloadType;

    public ServerboundDownloadRequest(BackupObject backup, DownloadType downloadType) {
        this.backup = backup;
        this.downloadType = downloadType;
    }

    public ServerboundDownloadRequest(FriendlyByteBuf buffer) {
        this.backup = BackupObject.decode(buffer);
        this.downloadType = (DownloadType)buffer.m_130066_(DownloadType.class);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        BackupObject.encode(buffer, this.backup);
        buffer.m_130068_((Enum)this.downloadType);
    }

    @Override
    public void apply(NetworkManager.PacketContext context) {
        if (this.isNotFromOperator(context)) {
            return;
        }
        Path path = this.backup.getPath();
        String filename = path.getFileName().toString();
        this.log("Player (%s) requested and was sent (%s)", this.getPlayerName(context), filename);
        PacketUtil.sendToPlayer(this.getServerPlayer(context), new ClientboundBackupDownload(this.backup, this.downloadType));
    }
}

