/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.tweak;

import dev.architectury.networking.NetworkManager;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.cache.CacheMode;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.TweakStatus;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import net.minecraft.network.FriendlyByteBuf;

public class ClientboundStatusUpdate
implements TweakPacket {
    protected final String poolId;
    protected final TweakStatus status;

    public ClientboundStatusUpdate(Tweak<?> tweak) {
        this.poolId = tweak.getJsonPathId();
        this.status = tweak.getEnvStatus();
    }

    public ClientboundStatusUpdate(FriendlyByteBuf buffer) {
        this.poolId = buffer.m_130277_();
        this.status = (TweakStatus)buffer.m_130066_(TweakStatus.class);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.poolId);
        buffer.m_130068_((Enum)this.status);
    }

    @Override
    public void apply(NetworkManager.PacketContext context) {
        if (this.isServerHandling(context)) {
            return;
        }
        this.findOnClient(this.poolId).ifPresent(tweak -> tweak.setStatus(CacheMode.NETWORK, this.status));
        String output = "Received tweak update from server: [tweak={jsonId:%s, status:%s}]";
        String jsonId = LogColor.apply(LogColor.LIGHT_PURPLE, this.poolId);
        String status = TweakStatus.toStringWithColor(this.status);
        NostalgicTweaks.LOGGER.debug(output, jsonId, status);
    }
}

