/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.tweak;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.function.Function;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakEnum;
import net.minecraft.network.FriendlyByteBuf;

abstract class TweakEnumPacket
implements TweakPacket {
    protected final String poolId;
    protected final String enumJson;

    TweakEnumPacket(TweakEnum<?> tweak, Function<TweakEnum<?>, Enum<?>> reader) {
        this.poolId = tweak.getJsonPathId();
        this.enumJson = new Gson().toJson(reader.apply(tweak));
    }

    TweakEnumPacket(FriendlyByteBuf buffer) {
        this.poolId = buffer.m_130277_();
        this.enumJson = buffer.m_130277_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.poolId);
        buffer.m_130070_(this.enumJson);
    }

    Object getReceivedEnum(Tweak<?> tweak) {
        try {
            return new Gson().fromJson(this.enumJson, tweak.getGenericType());
        }
        catch (JsonSyntaxException exception) {
            NostalgicTweaks.LOGGER.error("Could not parse enum for [tweak={jsonId:%s}]\n%s", new Object[]{this.poolId, exception});
            return null;
        }
    }
}

