/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.tweak;

import java.util.function.Function;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.tweak.listing.ListingPackager;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

abstract class TweakListingPacket<T extends TweakListing<?, ?>>
implements TweakPacket {
    protected final ListingPackager<T> packager;
    protected final String poolId;
    protected final boolean disabled;

    TweakListingPacket(T tweak, Function<T, ? extends Listing<?, ?>> reader) {
        this.poolId = ((Tweak)tweak).getJsonPathId();
        this.disabled = reader.apply(tweak).isDisabled();
        this.packager = new ListingPackager<T>(tweak, this.disabled);
    }

    TweakListingPacket(FriendlyByteBuf buffer, Class<? super T> classType) {
        this.poolId = buffer.m_130277_();
        this.disabled = buffer.readBoolean();
        this.packager = new ListingPackager<T>(this.poolId, classType, this.disabled);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.poolId);
        buffer.writeBoolean(this.disabled);
    }

    @Nullable
    protected T getTweak() {
        return this.packager.getTweak();
    }
}

