/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.tweak;

import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakNumber;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.network.FriendlyByteBuf;

abstract class TweakNumberPacket
implements TweakPacket {
    protected final String poolId;
    protected final double doubleValue;

    TweakNumberPacket(TweakNumber<? extends Number> tweak, Number number) {
        this.poolId = tweak.getJsonPathId();
        this.doubleValue = number.doubleValue();
    }

    TweakNumberPacket(FriendlyByteBuf buffer) {
        this.poolId = buffer.m_130277_();
        this.doubleValue = buffer.readDouble();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.poolId);
        buffer.writeDouble(this.doubleValue);
    }

    Number getReceivedNumber(Tweak<?> tweak) {
        return MathUtil.getNumberFromType(tweak.getGenericType(), this.doubleValue);
    }
}

