/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.tweak.container.ContainerBuilder;
import mod.adrenix.nostalgic.tweak.container.ContainerType;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class Container {
    public static final LinkedHashSet<Container> CATEGORIES = new LinkedHashSet();
    public static final LinkedHashSet<Container> GROUPS = new LinkedHashSet();
    private final ContainerType type;
    private final String jsonId;
    @Nullable
    private final Color color;
    @Nullable
    private final TextureIcon icon;
    @Nullable
    private final Container parent;
    @Nullable
    private final Container inheritance;
    private final boolean description;
    private final boolean internal;
    private final LinkedHashSet<Tweak<?>> tweaks = new LinkedHashSet();
    private Container category;

    public static ContainerBuilder category(String jsonId) {
        return new ContainerBuilder(jsonId, ContainerType.CATEGORY);
    }

    public static ContainerBuilder group(Container parent, String id) {
        return new ContainerBuilder(id, ContainerType.GROUP).parent(parent);
    }

    private static void inspect(Container container) {
        try {
            container.getTweaks().forEach(tweak -> {
                if (NostalgicTweaks.isServer() && tweak.isClient()) {
                    return;
                }
                tweak.getJsonId();
            });
        }
        catch (Throwable throwable) {
            String header = String.format("Container (%s) failed inspection: ", container.getJsonPathId());
            String message = header + throwable.getMessage();
            throw new AssertionError(message, throwable.getCause());
        }
    }

    public static void scanForIssues() {
        CATEGORIES.forEach(Container::inspect);
        GROUPS.forEach(Container::inspect);
    }

    Container(ContainerBuilder builder) {
        this.jsonId = builder.jsonId;
        this.type = builder.type;
        this.color = builder.color;
        this.icon = builder.icon;
        this.internal = builder.internal;
        this.description = builder.description;
        this.inheritance = builder.inheritance;
        if (this.type == ContainerType.CATEGORY) {
            this.parent = null;
            this.category = this;
            if (this.isDuplicated(CATEGORIES, this)) {
                throw new AssertionError((Object)String.format("Cannot have duplicate categories (%s)", this.getJsonPathId()));
            }
            if (!this.isRoot()) {
                CATEGORIES.add(this);
            }
        } else {
            this.parent = builder.parent;
            this.category = this.getCategory();
            if (this.isDuplicated(GROUPS, this)) {
                throw new AssertionError((Object)String.format("Cannot have duplicate groups (%s)", this.getJsonPathId()));
            }
            GROUPS.add(this);
        }
    }

    public void addTweak(Tweak<?> tweak) {
        this.tweaks.add(tweak);
    }

    public LinkedHashSet<Tweak<?>> getTweaks() {
        LinkedHashSet tweaks = new LinkedHashSet();
        if (this.inheritance != null) {
            tweaks.addAll(this.inheritance.getTweaks());
        }
        tweaks.addAll(this.tweaks.stream().filter(Tweak::isTop).toList());
        tweaks.addAll(CollectionUtil.filterOut(this.tweaks, Tweak::isIgnored, Tweak::isTop).toList());
        return tweaks;
    }

    public LinkedHashSet<Tweak<?>> getDeepTweaks() {
        LinkedHashSet<Tweak<?>> tweaks = this.getTweaks();
        if (!this.getChildren().isEmpty()) {
            this.getChildren().stream().map(Container::getDeepTweaks).forEach(tweaks::addAll);
        }
        return tweaks;
    }

    private boolean isDuplicated(LinkedHashSet<Container> checkSet, Container container) {
        Optional<Container> duplicate = checkSet.stream().filter(checking -> Objects.equals(checking.getJsonPathId(), container.getJsonPathId()) && !checking.equals(container)).findFirst();
        return duplicate.isPresent();
    }

    public Color getColor(Color color) {
        return Optional.ofNullable(this.color).orElse(color);
    }

    public Color getColor(int color) {
        return Optional.ofNullable(this.color).orElse(new Color(color));
    }

    public Color getColor() {
        return Optional.ofNullable(this.color).orElse(Color.WHITE);
    }

    public boolean isColorEmpty() {
        return Optional.ofNullable(this.color).isEmpty();
    }

    public TextureIcon getIcon() {
        return Optional.ofNullable(this.icon).orElse(TextureIcon.EMPTY);
    }

    public Optional<Container> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public Optional<Translation> getDescription() {
        if (!this.description) {
            return Optional.empty();
        }
        String key = String.format("gui.%s.container.%s.info", "nostalgic_tweaks", this.getJsonPathId());
        return Optional.of(new Translation(key));
    }

    public ContainerType getType() {
        return this.type;
    }

    public boolean isCategory() {
        return this.type == ContainerType.CATEGORY;
    }

    public boolean isGroup() {
        return this.type == ContainerType.GROUP;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isRoot() {
        return this.jsonId.isBlank();
    }

    public LinkedHashSet<Container> getGroupSetToCategory() {
        LinkedHashSet<Container> containers = new LinkedHashSet<Container>(List.of(this));
        Container scanning = this.parent;
        if (this.parent == null) {
            return containers;
        }
        containers.add(this.parent);
        while (scanning.getParent().isPresent() && !scanning.isRoot()) {
            scanning = scanning.getParent().get();
            containers.add(scanning);
        }
        return containers;
    }

    public LinkedHashSet<Container> getGroupSetFromCategory() {
        ArrayList<Container> containers = new ArrayList<Container>(this.getGroupSetToCategory());
        Collections.reverse(containers);
        return new LinkedHashSet<Container>(containers);
    }

    public LinkedHashSet<Container> getChildren() {
        LinkedHashSet<Container> groups = new LinkedHashSet<Container>();
        GROUPS.stream().filter(group -> group.getParent().stream().anyMatch(this::equals)).forEachOrdered(groups::add);
        return groups;
    }

    public Container getCategory() {
        if (this.parent == null) {
            return this;
        }
        if (this.category != null) {
            return this.category;
        }
        this.category = CollectionUtil.last(this.getGroupSetToCategory()).orElse(this);
        return this.category;
    }

    private HashSet<Container> getContainersForIndent() {
        LinkedHashSet<Container> groups = this.getGroupSetFromCategory();
        groups.remove(this.getCategory());
        return groups;
    }

    public int getIndentForGroupRow() {
        HashSet<Container> forIndent = this.getContainersForIndent();
        if (forIndent.size() == 1) {
            return 0;
        }
        return Math.max(0, forIndent.size() - 1) * 20;
    }

    public int getIndentForTweakRow() {
        if (this.isRoot()) {
            return 0;
        }
        return this.getContainersForIndent().size() * 20;
    }

    public String getJsonPathId() {
        return this.parent != null ? String.format("%s.%s", this.getCategory().jsonId, this.jsonId) : this.jsonId;
    }

    public String getJsonId() {
        return this.jsonId;
    }

    public String toString() {
        if (this.type == ContainerType.CATEGORY) {
            if (this.isRoot()) {
                return Component.m_237115_((String)String.format("gui.%s.container", "nostalgic_tweaks")).getString();
            }
            String category = "gui.%s.container.%s";
            return Component.m_237115_((String)String.format(category, "nostalgic_tweaks", this.jsonId)).getString();
        }
        return Component.m_237115_((String)String.format("gui.%s.container.%s.%s", "nostalgic_tweaks", this.getCategory().jsonId, this.jsonId)).getString();
    }
}

