/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.AfterConfigSave;
import mod.adrenix.nostalgic.client.gui.toast.ToastNotification;
import mod.adrenix.nostalgic.config.cache.CacheHolder;
import mod.adrenix.nostalgic.config.cache.CacheMode;
import mod.adrenix.nostalgic.config.cache.ConfigReflect;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.TweakIssue;
import mod.adrenix.nostalgic.tweak.TweakResult;
import mod.adrenix.nostalgic.tweak.TweakStatus;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.TweakBuilder;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPipeline;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import mod.adrenix.nostalgic.util.common.lang.DecodeLang;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class Tweak<T>
implements TweakMeta<T> {
    protected final TweakBuilder<?> builder;
    protected final Set<Runnable> reflectionListeners;
    private final Supplier<Boolean> modConflict;
    private final FlagHolder networkSync;
    private final TweakResult<T> resultSupplier;
    private final CacheHolder<TweakStatus> statusHolder;
    private CacheMode cacheMode;
    private String jsonId = null;

    Tweak(TweakBuilder<?> builder) {
        this.builder = builder;
        this.cacheMode = CacheMode.LOCAL;
        this.networkSync = FlagHolder.off();
        this.modConflict = Suppliers.memoize(() -> builder.conflictMods.stream().anyMatch(ModTracker::isInstalled));
        this.statusHolder = CacheHolder.from(builder.status, this::getCacheMode);
        this.resultSupplier = new TweakResult<Object>(this::result);
        this.reflectionListeners = new HashSet<Runnable>();
        builder.container.addTweak(this);
    }

    protected abstract String getTypeName();

    private void setJsonId(String jsonId) {
        this.jsonId = jsonId;
    }

    public String getJsonId() {
        if (this.jsonId == null) {
            throw new AssertionError((Object)String.format("Tweak (%s) has not set a config json identifier", this.getTypeName()));
        }
        return this.jsonId;
    }

    public String getJsonPathId() {
        if (this.getContainer().isRoot()) {
            return this.getJsonId();
        }
        return this.getCategory().getJsonId() + "." + this.getJsonId();
    }

    @Override
    public T register(String jsonId) {
        this.setJsonId(jsonId);
        TweakPool.TWEAK_MAP.putIfAbsent(this.getJsonPathId(), this);
        return this.getDefault();
    }

    @Override
    public T get() {
        return this.resultSupplier.get();
    }

    protected T result() {
        if (!this.isExtraConditionMet()) {
            return this.getDisabled();
        }
        return TweakPipeline.get(this);
    }

    public void invalidate() {
        this.resultSupplier.clear();
    }

    public TweakEnv getEnv() {
        return this.builder.env;
    }

    public boolean isClient() {
        return this.getEnv() == TweakEnv.CLIENT;
    }

    public boolean isServer() {
        return this.getEnv() == TweakEnv.SERVER;
    }

    public boolean isDynamic() {
        return this.getEnv() == TweakEnv.DYNAMIC;
    }

    public boolean isMultiplayerLike() {
        return this.isServer() || this.isDynamic();
    }

    public Container getContainer() {
        return this.builder.container;
    }

    public Container getCategory() {
        return this.builder.container.getCategory();
    }

    @Override
    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    @Override
    public boolean isCurrentCacheSavable() {
        return switch (this.cacheMode) {
            default -> throw new IncompatibleClassChangeError();
            case CacheMode.LOCAL -> this.isLocalSavable();
            case CacheMode.NETWORK -> this.isNetworkSavable();
        };
    }

    @Override
    public boolean isCacheUndoable() {
        return switch (this.cacheMode) {
            default -> throw new IncompatibleClassChangeError();
            case CacheMode.LOCAL -> this.isLocalSavable();
            case CacheMode.NETWORK -> this.isNetworkSavable();
        };
    }

    protected void sendIfPossible() {
        if (NostalgicTweaks.isServer()) {
            throw new RuntimeException("Server tried to access client-only tweak method");
        }
        if (NostalgicTweaks.isNetworkVerified() && this.isMultiplayerLike()) {
            if (NetUtil.isPlayerOp() && NetUtil.isMultiplayer()) {
                ToastNotification.changeOnServer();
                this.sendToServer();
            } else {
                this.setReceived(this.fromServer());
            }
        }
    }

    protected void updateReloadFlags() {
        if (NostalgicTweaks.isServer()) {
            throw new RuntimeException("Server tried to access client-only tweak method");
        }
        if (this.isChunkReloadRequired()) {
            AfterConfigSave.setChunksToReload();
        }
        if (this.isResourceReloadRequired()) {
            AfterConfigSave.setResourcesToReload();
        }
    }

    @Override
    public void applyCurrentCache() {
        if (NostalgicTweaks.isServer()) {
            throw new RuntimeException("Server tried to access client-only tweak method");
        }
        this.updateReloadFlags();
        switch (this.cacheMode) {
            case LOCAL: {
                this.setDisk(this.fromLocal());
                break;
            }
            case NETWORK: {
                this.sendIfPossible();
            }
        }
        if (NetUtil.isLocalHost() && this.isMultiplayerLike()) {
            this.sendToAll();
        }
    }

    @Override
    public void applyCacheAndSend() {
        if (NostalgicTweaks.isServer()) {
            throw new RuntimeException("Server tried to access client-only tweak method");
        }
        this.updateReloadFlags();
        this.setDisk(this.fromLocal());
        this.sendIfPossible();
        if (NetUtil.isLocalHost() && this.isMultiplayerLike()) {
            this.sendToAll();
        }
    }

    @Override
    public void applyReflection(T value) {
        this.runReflectionListeners();
        if (NostalgicTweaks.isClient()) {
            ConfigReflect.setClientField(this, value);
        } else {
            ConfigReflect.setServerField(this, value);
        }
    }

    public void whenChanged(Runnable runnable) {
        this.reflectionListeners.add(runnable);
    }

    protected void runReflectionListeners() {
        this.reflectionListeners.forEach(listener -> {
            NostalgicTweaks.LOGGER.debug("[Reflection Listener] Running for (%s)", this.toString());
            listener.run();
        });
    }

    public void connect() {
        if (NostalgicTweaks.isServer()) {
            throw new RuntimeException("Server tried to access client-only tweak method");
        }
        this.networkSync.enable();
    }

    public void disconnect() {
        if (NostalgicTweaks.isServer()) {
            throw new RuntimeException("Server tried to access client-only tweak method");
        }
        this.networkSync.disable();
    }

    public boolean isConnected() {
        if (NostalgicTweaks.isServer()) {
            throw new RuntimeException("Server tried to access client-only tweak method");
        }
        if (this.isClient()) {
            return true;
        }
        return (Boolean)this.networkSync.get();
    }

    public boolean isNotConnected() {
        return !this.isConnected();
    }

    public boolean isNew() {
        return this.builder.newForUpdate;
    }

    public boolean isOld() {
        return !this.isNew();
    }

    public boolean isNetworkCheckIgnored() {
        return this.builder.noNetworkCheck;
    }

    public boolean isNetworkAvailable() {
        return this.isMultiplayerLike() && NostalgicTweaks.isNetworkVerified() && NetUtil.isMultiplayer() && !NetUtil.isLocalHost();
    }

    public boolean isNetworkUnavailable() {
        return !this.isNetworkAvailable();
    }

    @Override
    public boolean isNetworkSavable() {
        return this.isNetworkAvailable() && this.isCacheSavable(this.fromServer(), this.fromNetwork());
    }

    public boolean isNetworkLocked() {
        if (NostalgicTweaks.isServer() || this.isClient() || this.isLocalMode()) {
            return false;
        }
        if (NetUtil.isSingleplayer() || NetUtil.isLocalHost() || !NostalgicTweaks.isNetworkVerified()) {
            return false;
        }
        return !NetUtil.isPlayerOp();
    }

    public boolean isNetworkUnlocked() {
        return !this.isNetworkLocked();
    }

    public boolean isWarningTag() {
        return this.builder.hasWarningTag;
    }

    public boolean isAlertTag() {
        return this.builder.alert.getCondition().get();
    }

    public boolean isNotSSO() {
        return this.builder.noSSO;
    }

    public boolean isChunkReloadRequired() {
        return this.builder.doesChunkReload;
    }

    public boolean isResourceReloadRequired() {
        return this.builder.doesResourceReload;
    }

    public boolean isTop() {
        return this.builder.top;
    }

    public boolean isIgnored() {
        return this.builder.ignoreIf.getAsBoolean();
    }

    public boolean isNotIgnored() {
        return !this.isIgnored();
    }

    public boolean isInternal() {
        return this.getCategory().isInternal() || this.getContainer().getGroupSetToCategory().stream().anyMatch(Container::isInternal);
    }

    public boolean isNotInternal() {
        return !this.isInternal();
    }

    public boolean isModConflict() {
        return this.modConflict.get();
    }

    public void setStatus(CacheMode cacheMode, TweakStatus status) {
        switch (cacheMode) {
            case LOCAL: {
                this.statusHolder.setLocal(status);
                break;
            }
            case NETWORK: {
                this.statusHolder.setNetwork(status);
            }
        }
    }

    public void setEnvStatus(TweakStatus status) {
        this.statusHolder.setLocal(status);
    }

    public TweakStatus getStatus() {
        if (NostalgicTweaks.isServer()) {
            return this.statusHolder.getLocal();
        }
        return this.statusHolder.get();
    }

    public TweakStatus getStatus(CacheMode cacheMode) {
        return switch (cacheMode) {
            default -> throw new IncompatibleClassChangeError();
            case CacheMode.LOCAL -> this.statusHolder.getLocal();
            case CacheMode.NETWORK -> this.statusHolder.getNetwork();
        };
    }

    public TweakStatus getEnvStatus() {
        return this.statusHolder.getLocal();
    }

    public boolean isLoaded() {
        return this.getStatus() == TweakStatus.LOADED;
    }

    public boolean isConflictOrFail() {
        return this.getStatus() == TweakStatus.FAIL || this.isModConflict();
    }

    public boolean isExtraConditionMet() {
        return this.builder.andIf.getAsBoolean();
    }

    public Set<TweakIssue> getModIssues() {
        return Collections.unmodifiableSet(this.builder.modIssues);
    }

    public String getLangKey() {
        String modId = "nostalgic_tweaks";
        String categoryJsonId = this.getCategory().getJsonId();
        String jsonId = this.jsonId;
        if (this.getContainer().isRoot()) {
            return String.format("gui.%s.config.%s", modId, jsonId);
        }
        return String.format("gui.%s.config.%s.%s", modId, categoryJsonId, jsonId);
    }

    public Component getTranslation() {
        return Component.m_237115_((String)this.getLangKey());
    }

    public int compareTranslationName(Tweak<?> tweak) {
        return this.getTranslation().getString().compareToIgnoreCase(tweak.getTranslation().getString());
    }

    public Component getDescription() {
        return DecodeLang.findAndReplace((Component)Component.m_237115_((String)(this.getLangKey() + ".info")));
    }

    public Component getConflictMessage() {
        return DecodeLang.findAndReplace((Component)Component.m_237115_((String)(this.getLangKey() + ".conflict")));
    }

    public Component getWarningMessage() {
        return DecodeLang.findAndReplace((Component)Component.m_237115_((String)(this.getLangKey() + ".warn")));
    }

    public Component getAlertMessage() {
        return DecodeLang.findAndReplace(this.builder.alert.getMessage());
    }

    public Component getNoSSOMessage() {
        String langKey = this.getLangKey() + ".no_sso";
        MutableComponent message = DecodeLang.findAndReplace((Component)Component.m_237115_((String)langKey));
        if (message.getString().equals(langKey)) {
            return Lang.Tag.NO_SSO_TOOLTIP.get(new Object[0]);
        }
        return message;
    }

    public String toString() {
        String format = "[tweak={jsonId:%s, type:%s}]";
        String jsonId = this.getJsonPathId();
        String type = this.getTypeName();
        return String.format(format, jsonId, type);
    }
}

