/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import java.util.Set;
import mod.adrenix.nostalgic.network.packet.tweak.ClientboundTweakFlag;
import mod.adrenix.nostalgic.network.packet.tweak.ServerboundTweakFlag;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.TweakValue;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import org.jetbrains.annotations.Nullable;

public class TweakFlag
extends TweakValue<Boolean> {
    public static Builder client(boolean defaultFlag, Container container) {
        return new Builder(defaultFlag, TweakEnv.CLIENT, container);
    }

    public static Builder server(boolean defaultFlag, Container container) {
        return new Builder(defaultFlag, TweakEnv.SERVER, container);
    }

    public static Builder dynamic(boolean defaultFlag, Container container) {
        return new Builder(defaultFlag, TweakEnv.DYNAMIC, container);
    }

    TweakFlag(Builder builder) {
        super(builder);
    }

    private Builder getBuilder() {
        return (Builder)this.builder;
    }

    @Override
    protected Boolean result() {
        return (Boolean)super.result() != false || this.getBuilder().orIf.stream().anyMatch(BooleanSupplier::getAsBoolean);
    }

    @Override
    @Nullable
    public TweakPacket getClientboundPacket() {
        return new ClientboundTweakFlag(this);
    }

    @Override
    @Nullable
    public TweakPacket getServerboundPacket() {
        return new ServerboundTweakFlag(this);
    }

    public static class Builder
    extends TweakValue.Builder<Boolean, Builder> {
        Set<BooleanSupplier> orIf = Set.of(BooleanSupplier.NEVER);

        Builder(Boolean defaultValue, TweakEnv env, Container container) {
            super(defaultValue, env, container);
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        public Builder whenDisabled(Boolean value) {
            return (Builder)super.whenDisabled(value);
        }

        public Builder orIf(BooleanSupplier ... conditions) {
            this.orIf = Set.of(conditions);
            return this.self();
        }

        public TweakFlag build() {
            return new TweakFlag(this);
        }
    }
}

