/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import java.util.Optional;
import mod.adrenix.nostalgic.config.cache.CacheHolder;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.TweakValidator;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakBuilder;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;

public abstract class TweakListing<V, T extends Listing<V, T>>
extends Tweak<T> {
    private final Builder<?, V, T> builder;
    private final CacheHolder<T> cacheHolder;
    private final T emptyList;
    private final T diskList;
    private final T defaultList;
    private final T receivedList;

    TweakListing(Builder<?, V, T> builder) {
        super(builder);
        this.builder = builder;
        this.defaultList = builder.defaultList;
        this.receivedList = builder.defaultList.create();
        this.diskList = builder.defaultList.create();
        this.emptyList = builder.defaultList.create();
        this.cacheHolder = CacheHolder.with(this.defaultList.create(), this.defaultList.create(), this::getCacheMode);
        this.reflectionListeners.add(() -> this.diskList.resetTransientCache());
        this.emptyList.clear();
    }

    @Override
    public T get() {
        if (this.diskList.isDisabled()) {
            return this.emptyList;
        }
        return (T)((Listing)super.get());
    }

    @Override
    public T fromDisk() {
        return this.diskList;
    }

    @Override
    public T fromServer() {
        return this.receivedList;
    }

    @Override
    public CacheHolder<T> getCacheHolder() {
        return this.cacheHolder;
    }

    @Override
    public void setCacheValue(T value) {
        if (this.isLocalMode()) {
            ((Listing)this.fromLocal()).clear();
            ((Listing)this.fromLocal()).copy(value);
        } else {
            ((Listing)this.fromNetwork()).clear();
            ((Listing)this.fromNetwork()).copy(value);
        }
    }

    @Override
    public void setCacheToDefault() {
        ((Listing)this.fromCache()).clear();
        ((Listing)this.fromCache()).copy(this.defaultList);
    }

    @Override
    public boolean isCacheDefault() {
        return ((Listing)this.fromCache()).matches(this.defaultList);
    }

    @Override
    public void setCacheDisabled() {
        ((Listing)this.fromCache()).setDisabled(true);
    }

    @Override
    public boolean isCacheDisabled() {
        return this.isIgnored() || ((Listing)this.fromCache()).isDisabled();
    }

    @Override
    public void applyCurrentCache() {
        switch (this.getCacheMode()) {
            case LOCAL: {
                ((Listing)this.fromLocal()).applyCache();
                break;
            }
            case NETWORK: {
                ((Listing)this.fromNetwork()).applyCache();
            }
        }
        super.applyCurrentCache();
    }

    @Override
    public void applyCacheAndSend() {
        ((Listing)this.fromLocal()).applyCache();
        ((Listing)this.fromNetwork()).applyCache();
        super.applyCacheAndSend();
    }

    @Override
    public void undoCache() {
        if (this.isLocalMode()) {
            ((Listing)this.fromLocal()).clear();
            ((Listing)this.fromLocal()).copy(this.fromDisk());
        } else {
            ((Listing)this.fromNetwork()).clear();
            ((Listing)this.fromNetwork()).copy(this.fromServer());
        }
    }

    @Override
    public boolean isNetworkSavable() {
        return this.isNetworkAvailable() && !this.fromServer().matches((Listing)this.fromNetwork());
    }

    @Override
    public boolean isLocalSavable() {
        return !this.fromDisk().matches((Listing)this.fromLocal());
    }

    @Override
    public void sync() {
        ((Listing)this.fromLocal()).clear();
        ((Listing)this.fromLocal()).copy(this.fromDisk());
        ((Listing)this.fromNetwork()).clear();
        ((Listing)this.fromNetwork()).copy(this.fromServer());
    }

    @Override
    public void setDisk(T value) {
        this.diskList.clear();
        this.diskList.copy(value);
        this.applyReflection(this.diskList);
    }

    @Override
    public void setReceived(T value) {
        this.receivedList.clear();
        this.receivedList.copy(value);
        this.receivedList.resetTransientCache();
        ((Listing)this.fromNetwork()).clear();
        ((Listing)this.fromNetwork()).copy(value);
    }

    @Override
    public T getDefault() {
        return this.defaultList;
    }

    @Override
    public T getDisabled() {
        if (this.isIgnored()) {
            return (T)this.fromDisk();
        }
        return this.emptyList;
    }

    @Override
    public void setDisabled(T value) {
    }

    @Override
    public boolean hasChanged(T receivedValue) {
        return !this.fromDisk().matches(receivedValue);
    }

    @Override
    public boolean validate(TweakValidator validator) {
        return this.diskList.validate(validator, this);
    }

    public Optional<TextureIcon> getIcon() {
        return Optional.ofNullable(this.builder.icon);
    }

    @Override
    protected String getTypeName() {
        return this.fromDisk().debugString();
    }

    public static abstract class Builder<B extends Builder<B, W, U>, W, U extends Listing<W, U>>
    extends TweakBuilder<B> {
        final U defaultList;
        TextureIcon icon;

        Builder(U defaultList, TweakEnv env, Container container) {
            super(env, container);
            this.defaultList = defaultList;
        }

        public B icon(TextureIcon icon) {
            this.icon = icon;
            return (B)((Builder)this.self());
        }
    }
}

