/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import java.util.Optional;
import java.util.function.Function;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.gui.SliderType;
import mod.adrenix.nostalgic.tweak.gui.TweakSlider;
import mod.adrenix.nostalgic.tweak.listing.ListingMap;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import org.jetbrains.annotations.Nullable;

public abstract class TweakMap<V, L extends ListingMap<V, L>>
extends TweakListing<V, L> {
    private final Builder<?, V, L> builder;

    TweakMap(Builder<?, V, L> builder) {
        super(builder);
        this.builder = builder;
    }

    public Optional<TweakSlider> getSlider() {
        if (this.builder.slider != null) {
            return Optional.of(this.builder.slider.build());
        }
        return Optional.empty();
    }

    public static Optional<TweakMap<?, ?>> cast(TweakListing<?, ?> tweak) {
        if (tweak instanceof TweakMap) {
            TweakMap map = (TweakMap)tweak;
            return Optional.of(map);
        }
        return Optional.empty();
    }

    public static abstract class Builder<B extends Builder<B, W, U>, W, U extends ListingMap<W, U>>
    extends TweakListing.Builder<B, W, U>
    implements TweakSlider.Factory<B> {
        private static final String NON_NUMBER_MAP = "Cannot define slider data for non-number map";
        @Nullable
        final TweakSlider.Builder slider;

        Builder(U defaultList, TweakEnv env, Container container) {
            super(defaultList, env, container);
            this.slider = Number.class.isAssignableFrom(((ListingMap)this.defaultList).genericType()) ? TweakSlider.create(null) : null;
        }

        @Override
        public B range(Number min, Number max) {
            if (this.slider == null) {
                throw new RuntimeException(NON_NUMBER_MAP);
            }
            this.slider.range(min, max);
            return (B)((Builder)this.self());
        }

        @Override
        public B interval(Number interval) {
            if (this.slider == null) {
                throw new RuntimeException(NON_NUMBER_MAP);
            }
            this.slider.interval(interval);
            return (B)((Builder)this.self());
        }

        @Override
        public B roundTo(int place) {
            if (this.slider == null) {
                throw new RuntimeException(NON_NUMBER_MAP);
            }
            this.slider.roundTo(place);
            return (B)((Builder)this.self());
        }

        @Override
        public B formatter(Function<Number, String> formatter) {
            if (this.slider == null) {
                throw new RuntimeException(NON_NUMBER_MAP);
            }
            this.slider.formatter((Function)formatter);
            return (B)((Builder)this.self());
        }

        @Override
        public B langKey(Translation langKey) {
            if (this.slider == null) {
                throw new RuntimeException(NON_NUMBER_MAP);
            }
            this.slider.langKey(langKey);
            return (B)((Builder)this.self());
        }

        @Override
        public B suffix(String suffix) {
            if (this.slider == null) {
                throw new RuntimeException(NON_NUMBER_MAP);
            }
            this.slider.suffix(suffix);
            return (B)((Builder)this.self());
        }

        @Override
        public B type(SliderType type) {
            if (this.slider == null) {
                throw new RuntimeException(NON_NUMBER_MAP);
            }
            this.slider.type(type);
            return (B)((Builder)this.self());
        }
    }
}

