/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import java.util.Optional;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.config.cache.CacheHolder;
import mod.adrenix.nostalgic.config.cache.CacheMode;
import mod.adrenix.nostalgic.config.cache.ConfigCache;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.TweakValidator;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public interface TweakMeta<T> {
    public T register(String var1);

    public T get();

    public T fromDisk();

    public T fromServer();

    default public T fromCache() {
        return this.getCacheHolder().get();
    }

    default public T fromMode() {
        return this.isLocalMode() ? this.fromDisk() : this.fromServer();
    }

    default public T fromLocal() {
        return this.getCacheHolder().getLocal();
    }

    default public void setLocal(T value) {
        this.getCacheHolder().setLocal(value);
    }

    default public T fromNetwork() {
        return this.getCacheHolder().getNetwork();
    }

    default public void setNetwork(T value) {
        this.getCacheHolder().setNetwork(value);
    }

    public CacheMode getCacheMode();

    public void setCacheMode(CacheMode var1);

    default public boolean isLocalMode() {
        return this.getCacheMode() == CacheMode.LOCAL;
    }

    default public boolean isNetworkMode() {
        return this.getCacheMode() == CacheMode.NETWORK;
    }

    default public void toggleCacheMode() {
        if (this.isLocalMode()) {
            this.setCacheMode(CacheMode.NETWORK);
        } else {
            this.setCacheMode(CacheMode.LOCAL);
        }
    }

    public CacheHolder<T> getCacheHolder();

    public void setCacheValue(T var1);

    public void setCacheToDefault();

    public boolean isCacheDefault();

    default public boolean isCacheNotDefault() {
        return !this.isCacheDefault();
    }

    default public boolean isCacheDisabled() {
        return this.fromCache().equals(this.getDisabled());
    }

    default public void setCacheDisabled() {
        this.setCacheValue(this.getDisabled());
    }

    default public boolean isCacheSavable(T value, T cacheValue) {
        if (value instanceof Byte && cacheValue instanceof Byte) {
            return ((Byte)value).compareTo((Byte)cacheValue) != 0;
        }
        if (value instanceof Short && cacheValue instanceof Short) {
            return ((Short)value).compareTo((Short)cacheValue) != 0;
        }
        if (value instanceof Integer && cacheValue instanceof Integer) {
            return ((Integer)value).compareTo((Integer)cacheValue) != 0;
        }
        if (value instanceof Long && cacheValue instanceof Long) {
            return ((Long)value).compareTo((Long)cacheValue) != 0;
        }
        if (value instanceof Float && cacheValue instanceof Float) {
            return ((Float)value).compareTo((Float)cacheValue) != 0;
        }
        if (value instanceof Double && cacheValue instanceof Double) {
            return ((Double)value).compareTo((Double)cacheValue) != 0;
        }
        return !value.equals(cacheValue);
    }

    default public boolean isLocalSavable() {
        return this.isCacheSavable(this.fromDisk(), this.fromLocal());
    }

    public boolean isNetworkSavable();

    default public boolean isAnyCacheSavable() {
        return this.isLocalSavable() || this.isNetworkSavable();
    }

    public boolean isCurrentCacheSavable();

    public boolean isCacheUndoable();

    default public boolean isCacheNotUndoable() {
        return !this.isCacheUndoable();
    }

    public void undoCache();

    public void applyCurrentCache();

    public void applyCacheAndSend();

    public void applyReflection(T var1);

    @Nullable
    public TweakPacket getClientboundPacket();

    @Nullable
    public TweakPacket getServerboundPacket();

    default public void sendToServer() {
        Optional.ofNullable(this.getServerboundPacket()).ifPresent(PacketUtil::sendToServer);
    }

    default public void sendToAll() {
        Optional.ofNullable(this.getClientboundPacket()).ifPresent(PacketUtil::sendToAll);
    }

    default public void sendToPlayer(ServerPlayer player) {
        Optional.ofNullable(this.getClientboundPacket()).ifPresent(packet -> PacketUtil.sendToPlayer(player, packet));
    }

    public void sync();

    public void setDisk(T var1);

    default public void setDiskAndSave(T value) {
        this.setDisk(value);
        ConfigCache.save();
    }

    default public void setCacheAndDisk(T value) {
        this.setCacheValue(value);
        this.setDisk(value);
    }

    default public void setCacheAndDiskThenSave(T value) {
        this.setCacheAndDisk(value);
        ConfigCache.save();
    }

    public void setReceived(T var1);

    public T getDefault();

    public T getDisabled();

    public void setDisabled(T var1);

    public boolean hasChanged(T var1);

    public boolean validate(TweakValidator var1);

    default public Class<T> getGenericType() {
        return this.getDefault().getClass();
    }

    public static Tweak<Object> wildcard(Tweak<?> meta) {
        return meta;
    }

    default public boolean applySafely(Object value, Consumer<Object> consumer) {
        Optional<Tweak<?>> cast = this.generic(value.getClass());
        cast.ifPresent(meta -> consumer.accept(value));
        return cast.isPresent();
    }

    public static <U> Optional<Tweak<U>> generic(TweakMeta<?> tweak, Class<? super U> genericType) {
        if (genericType.isAssignableFrom(tweak.getGenericType())) {
            return Optional.of((Tweak)tweak);
        }
        return Optional.empty();
    }

    default public <U> Optional<Tweak<U>> generic(Class<? super U> genericType) {
        return TweakMeta.generic(this, genericType);
    }

    public static <U> Optional<U> cast(TweakMeta<?> tweak, Class<? super U> widenType) {
        if (widenType.isAssignableFrom(tweak.getClass())) {
            return Optional.of(tweak);
        }
        return Optional.empty();
    }

    default public <U> Optional<U> cast(Class<? super U> widenType) {
        return TweakMeta.cast(this, widenType);
    }
}

