/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.cache.CacheMode;
import mod.adrenix.nostalgic.tweak.TweakStatus;
import mod.adrenix.nostalgic.tweak.container.Category;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakBinding;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;

public abstract class TweakPool {
    static final LinkedHashMap<String, Tweak<?>> TWEAK_MAP = new LinkedHashMap();
    private static boolean isCacheStatusUpdated = false;

    public static Optional<Tweak<?>> find(String poolId) {
        return Optional.ofNullable(TWEAK_MAP.get(poolId));
    }

    public static Collection<Tweak<?>> values() {
        return TWEAK_MAP.values();
    }

    public static Stream<Tweak<?>> stream() {
        return TweakPool.values().stream();
    }

    @SafeVarargs
    public static Stream<Tweak<?>> filter(Predicate<Tweak<?>> ... filters) {
        return CollectionUtil.filterAll(TweakPool.stream(), filters);
    }

    public static Stream<Tweak<?>> filter(Collection<Predicate<Tweak<?>>> filters) {
        return CollectionUtil.filterAll(TweakPool.stream(), filters);
    }

    public static void setAllFail() {
        if (isCacheStatusUpdated) {
            return;
        }
        TWEAK_MAP.forEach((key, tweak) -> {
            if (tweak.getEnvStatus() == TweakStatus.WAIT) {
                tweak.setEnvStatus(TweakStatus.FAIL);
            }
        });
        isCacheStatusUpdated = true;
    }

    public static void setAllCacheModes() {
        TWEAK_MAP.forEach((key, tweak) -> {
            if (NostalgicTweaks.isServer()) {
                return;
            }
            if (tweak.isNetworkAvailable()) {
                tweak.setCacheMode(CacheMode.NETWORK);
            } else {
                tweak.setCacheMode(CacheMode.LOCAL);
            }
        });
    }

    public static Stream<Tweak<Object>> automated(Collection<Predicate<Tweak<?>>> predicates) {
        return TweakPool.filter(predicates).filter(tweak -> ClassUtil.isNotInstanceOf(tweak, TweakBinding.class)).filter(tweak -> tweak.getCategory() != Category.ROOT).filter(tweak -> tweak.getCategory() != Category.MOD).filter(Tweak::isNotIgnored).filter(Tweak::isNotInternal).map(TweakMeta::wildcard);
    }

    public static Stream<Tweak<Object>> automated() {
        return TweakPool.automated(List.of());
    }
}

