/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.gui;

import mod.adrenix.nostalgic.util.common.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SliderType {
    GENERIC,
    HEARTS,
    SWING{

        @Override
        public Component getTranslation(Number value) {
            return Lang.Slider.SPEED.get(new Object[0]);
        }

        @Override
        public ChatFormatting getColor(Number value) {
            if (value.intValue() == -1) {
                return ChatFormatting.RED;
            }
            if (value.intValue() == 0) {
                return ChatFormatting.YELLOW;
            }
            if (value.intValue() < 6) {
                return ChatFormatting.GOLD;
            }
            return ChatFormatting.GREEN;
        }
    }
    ,
    INTENSITY{

        @Override
        public Component getTranslation(Number value) {
            return Lang.Slider.INTENSITY.get(new Object[0]);
        }

        @Override
        public Component getSuffix(Number value) {
            return Component.m_237113_((String)"%");
        }

        @Override
        public ChatFormatting getColor(Number value) {
            if (value.intValue() == 0) {
                return ChatFormatting.RED;
            }
            if (value.intValue() <= 50) {
                return ChatFormatting.GOLD;
            }
            if (value.intValue() > 100) {
                return ChatFormatting.AQUA;
            }
            return ChatFormatting.GREEN;
        }
    }
    ,
    CLOUD{

        @Override
        public Component getTranslation(Number value) {
            return switch (value.intValue()) {
                case 108 -> Lang.Enum.ALPHA.get(new Object[0]);
                case 128 -> Lang.Enum.BETA.get(new Object[0]);
                case 192 -> Lang.Enum.MODERN.get(new Object[0]);
                default -> Lang.Slider.CUSTOM.get(new Object[0]);
            };
        }

        @Override
        public ChatFormatting getColor(Number value) {
            if (value.intValue() == 128) {
                return ChatFormatting.YELLOW;
            }
            if (value.intValue() == 192) {
                return ChatFormatting.GOLD;
            }
            return ChatFormatting.LIGHT_PURPLE;
        }
    };


    public Component getTranslation(Number value) {
        return Component.m_237119_();
    }

    public Component getSuffix(Number value) {
        return Component.m_237119_();
    }

    public ChatFormatting getColor(Number value) {
        return ChatFormatting.RESET;
    }
}

