/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.listing;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.tweak.listing.ListingMap;
import org.jetbrains.annotations.Nullable;

public interface DeletableMap<V, L extends Listing<V, L>>
extends ListingMap<V, L> {
    public Map<String, V> getDeleted();

    @Override
    default public void acceptSafely(Map<String, ?> map) {
        map.forEach((key, value) -> this.applySafely((String)key, (Object)value, this::put));
    }

    @Override
    default public Collection<V> values() {
        LinkedHashSet<V> values = new LinkedHashSet<V>();
        values.addAll(this.getMap().values());
        values.addAll(this.getDeleted().values());
        return values;
    }

    @Override
    default public Set<Map.Entry<String, V>> entrySet() {
        LinkedHashSet<Map.Entry<String, V>> entries = new LinkedHashSet<Map.Entry<String, V>>();
        entries.addAll(this.getMap().entrySet());
        entries.addAll(this.getDeleted().entrySet());
        return entries;
    }

    default public void put(String key) {
        this.put(key, this.getDefaultValue());
    }

    default public V put(String key, V value) {
        this.getDeleted().remove(key, value);
        return this.getMap().put(key, value);
    }

    default public void putAll(Map<? extends String, ? extends V> map) {
        map.forEach(this.getDeleted()::remove);
        this.getMap().putAll(map);
    }

    default public void putAll(DeletableMap<V, L> deletable) {
        this.putAll(deletable.getMap());
    }

    @Nullable
    default public V getOrDeleted(String key) {
        if (this.getMap().containsKey(key)) {
            return this.getMap().get(key);
        }
        if (this.getDeleted().containsKey(key)) {
            return this.getDeleted().get(key);
        }
        return null;
    }

    default public boolean isDeleted(String key) {
        return this.getDeleted().containsKey(key);
    }

    default public void delete(String key, V value) {
        this.getDeleted().put(key, value);
        this.getMap().remove(key, value);
    }

    default public void remove(String key, V value) {
        this.getMap().remove(key, value);
        this.getDeleted().remove(key, value);
    }

    default public void undo(String key, V value) {
        this.getDeleted().remove(key);
        this.getMap().put(key, value);
    }

    default public void putIfAbsent(String key) {
        if (this.getDeleted().containsKey(key)) {
            this.undo(key, this.getDeleted().get(key));
        } else {
            this.getMap().putIfAbsent(key, this.getDefaultValue());
        }
    }

    default public void resetDeletedEntries() {
        this.getDeleted().clear();
    }

    default public void applyDeletedEntries() {
        this.getDeleted().forEach(this.getMap()::remove);
        this.resetDeletedEntries();
    }

    @Override
    default public void applyCache() {
        this.applyDeletedEntries();
    }

    default public <T> void applySafely(String key, T value, BiConsumer<String, V> consumer) {
        if (value.getClass().isAssignableFrom(this.genericType())) {
            consumer.accept(key, value);
        }
    }
}

