/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.listing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.tweak.listing.ListingSet;

public interface DeletableSet<E, L extends Listing<E, L>>
extends ListingSet<E, L> {
    public Set<E> getDeleted();

    @Override
    default public void acceptSafely(Set<?> set) {
        set.forEach(e -> this.applySafely(e, this::add));
    }

    @Override
    default public Stream<E> stream() {
        LinkedHashSet<E> elements = new LinkedHashSet<E>();
        elements.addAll(this.getSet());
        elements.addAll(this.getDeleted());
        return elements.stream();
    }

    default public boolean add(E element) {
        this.getDeleted().remove(element);
        return this.getSet().add(element);
    }

    default public void addAll(Collection<? extends E> collection) {
        collection.forEach(this.getDeleted()::remove);
        this.getSet().addAll(collection);
    }

    default public void addAll(DeletableSet<E, L> deletable) {
        this.addAll(deletable.getSet());
    }

    default public boolean isDeleted(E element) {
        return this.getDeleted().contains(element);
    }

    default public boolean contains(E element) {
        return this.getSet().contains(element);
    }

    default public void delete(E element) {
        this.getDeleted().add(element);
        this.getSet().remove(element);
    }

    default public void remove(E element) {
        this.getSet().remove(element);
        this.getDeleted().remove(element);
    }

    default public void undo(E element) {
        this.add(element);
    }

    default public void resetDeletedElements() {
        this.getDeleted().clear();
    }

    default public void applyDeletedElements() {
        Iterator<E> iterator = this.getDeleted().iterator();
        Set set = this.getSet();
        while (iterator.hasNext()) {
            set.remove(iterator.next());
            iterator.remove();
        }
        this.resetDeletedElements();
    }

    @Override
    default public void applyCache() {
        this.applyDeletedElements();
    }

    default public <T> void applySafely(T element, Consumer<E> consumer) {
        if (element.getClass().isAssignableFrom(this.genericType())) {
            consumer.accept(element);
        }
    }
}

