/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.listing;

import java.util.LinkedHashSet;
import mod.adrenix.nostalgic.tweak.TweakValidator;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.listing.DeletableSet;
import mod.adrenix.nostalgic.tweak.listing.ListingSuggestion;
import mod.adrenix.nostalgic.tweak.listing.ListingValidator;

public class StringSet
implements DeletableSet<String, StringSet> {
    private final LinkedHashSet<String> list = new LinkedHashSet();
    private final transient LinkedHashSet<String> deleted = new LinkedHashSet();
    private final transient ListingSuggestion suggestion;
    private boolean disabled;

    public StringSet() {
        this.suggestion = ListingSuggestion.NONE;
    }

    public StringSet(ListingSuggestion suggestion) {
        this.suggestion = suggestion;
    }

    public StringSet startWith(LinkedHashSet<String> set) {
        this.list.addAll(set);
        return this;
    }

    public ListingSuggestion getSuggestion() {
        return this.suggestion;
    }

    @Override
    public LinkedHashSet<String> getSet() {
        return this.list;
    }

    @Override
    public LinkedHashSet<String> getDeleted() {
        return this.deleted;
    }

    @Override
    public StringSet create() {
        return new StringSet(this.suggestion);
    }

    @Override
    public void copy(StringSet list) {
        this.addAll(list.list);
        this.disabled = list.disabled;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.deleted.clear();
    }

    @Override
    public boolean matches(StringSet listing) {
        return this.list.equals(listing.list) && this.disabled == listing.disabled;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.list.contains(object);
    }

    @Override
    public boolean validate(TweakValidator validator, TweakListing<String, StringSet> tweak) {
        return ListingValidator.set(this, this.list, validator, tweak);
    }

    @Override
    public void setDisabled(boolean state) {
        this.disabled = state;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public Class<String> genericType() {
        return String.class;
    }

    @Override
    public String debugString() {
        return String.format("StringSet{size:%s, disabled:%s}", this.list.size(), this.disabled);
    }

    public String toString() {
        return this.debugString();
    }
}

