/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.util.common.ClassUtil;

public enum ModTracker {
    DISTANT_HORIZONS("distanthorizons"),
    CONTROLIFY("controlify"),
    APPLE_SKIN("appleskin"),
    SODIUM("sodium", "embeddium", "rubidium"),
    STARLIGHT("starlight"),
    POLYTONE("polytone"),
    EXORDIUM("exordium"),
    OPTIFINE("optifine"),
    FLYWHEEL("flywheel"),
    IRIS("iris");

    private final String[] identifiers;
    private boolean installed;
    private static final Supplier<Boolean> OPTIFINE_SUPPLIER;

    private ModTracker(String ... identifiers) {
        this.identifiers = identifiers;
    }

    public static Stream<ModTracker> stream() {
        return Arrays.stream(ModTracker.values());
    }

    public static void init(Function<String, Boolean> loader) {
        ModTracker.stream().forEach(mod -> {
            for (String id : mod.identifiers) {
                if (mod.installed) break;
                mod.installed = (Boolean)loader.apply(id);
            }
        });
    }

    public boolean isInstalled() {
        if (this.equals((Object)OPTIFINE)) {
            return OPTIFINE_SUPPLIER.get();
        }
        return this.installed;
    }

    public boolean isNotInstalled() {
        return !this.isInstalled();
    }

    static {
        OPTIFINE_SUPPLIER = Suppliers.memoize(ClassUtil::isOptifinePresent);
    }
}

