/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.listing.ItemSet;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class GameUtil {
    public static final FlagHolder MOB_EFFECT_ACTIVE = FlagHolder.off();

    public static String getVersion() {
        return SharedConstants.m_183709_().m_132493_();
    }

    public static boolean isOnIntegratedSeverThread() {
        IntegratedServer integratedServer = Minecraft.m_91087_().m_91092_();
        if (integratedServer == null) {
            return false;
        }
        return Thread.currentThread() == integratedServer.m_6304_();
    }

    public static boolean isCreativeMode() {
        return Minecraft.m_91087_().f_91072_ != null && Minecraft.m_91087_().f_91072_.m_105290_();
    }

    public static boolean isNotCreativeMode() {
        return !GameUtil.isCreativeMode();
    }

    public static boolean isSpectatorMode() {
        return Minecraft.m_91087_().f_91072_ != null && Minecraft.m_91087_().f_91072_.m_105293_();
    }

    public static boolean isNotSpectatorMode() {
        return !GameUtil.isSpectatorMode();
    }

    public static boolean isSurvivalMode() {
        return GameUtil.isNotCreativeMode() && GameUtil.isNotSpectatorMode();
    }

    public static boolean isNotSurvivalMode() {
        return !GameUtil.isSurvivalMode();
    }

    @Nullable
    public static MinecraftServer getIntegratedServer() {
        return Minecraft.m_91087_().m_91092_();
    }

    @Nullable
    public static ServerLevel getOverworldLevel() {
        if (Minecraft.m_91087_().m_91092_() == null) {
            return null;
        }
        return Minecraft.m_91087_().m_91092_().m_129880_(Level.f_46428_);
    }

    public static boolean isInOverworld() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level != null && level.m_46472_().equals(Level.f_46428_);
    }

    public static boolean isInNether() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level != null && level.m_46472_().equals(Level.f_46429_);
    }

    public static boolean isInEnd() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level != null && level.m_46472_().equals(Level.f_46430_);
    }

    public static boolean isModelFlat(ItemStack itemStack) {
        boolean usesBlockLight = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, null, null, 0).m_7547_();
        boolean isException = ((ItemSet)CandyTweak.OLD_2D_EXCEPTIONS.get()).containsItem(itemStack);
        return !usesBlockLight && !isException;
    }

    public static boolean isModelFlat(Item item) {
        return GameUtil.isModelFlat(item.m_7968_());
    }

    public static int getRenderDistance() {
        return Minecraft.m_91087_().f_91066_.m_193772_();
    }

    public static int getOldRenderDistance() {
        int renderDistance = GameUtil.getRenderDistance();
        if (renderDistance >= 16) {
            return 0;
        }
        if (renderDistance >= 8) {
            return 1;
        }
        if (renderDistance >= 4) {
            return 2;
        }
        return 3;
    }
}

