/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public abstract class KeyboardUtil {
    private static final Map<String, KeyMapping> MAPPING_CACHE = new HashMap<String, KeyMapping>();

    public static boolean isModifierDown() {
        return Screen.m_96638_() || Screen.m_96637_() || Screen.m_96639_();
    }

    public static boolean isGoingRight(int key) {
        if (Screen.m_96638_()) {
            return false;
        }
        return (Screen.m_96637_() || Screen.m_96639_()) && key == 262;
    }

    public static boolean isGoingLeft(int key) {
        if (Screen.m_96638_()) {
            return false;
        }
        return (Screen.m_96637_() || Screen.m_96639_()) && key == 263;
    }

    public static boolean isSearching(int key) {
        if (Screen.m_96638_()) {
            return false;
        }
        return Screen.m_96637_() && key == 70;
    }

    public static boolean isSaving(int key) {
        if (Screen.m_96638_()) {
            return false;
        }
        return Screen.m_96637_() && key == 83;
    }

    public static boolean isSelectAll(int key) {
        if (Screen.m_96638_()) {
            return false;
        }
        return Screen.m_96637_() && key == 65;
    }

    public static boolean isEnterLike(int key) {
        return key == 257 || key == 335 || key == 32;
    }

    public static boolean isReturnOrEnter(int key) {
        return key == 257 || key == 335;
    }

    public static boolean isTab(int key) {
        return key == 258;
    }

    public static boolean isEsc(int key) {
        return key == 256;
    }

    public static boolean isDown(int key) {
        return InputConstants.m_84830_((long)GuiUtil.getWindowPointer(), (int)key);
    }

    public static boolean match(int keyCode, int ... keys) {
        return Arrays.stream(keys).anyMatch(key -> key == keyCode);
    }

    public static Optional<KeyMapping> find(String langKey) {
        KeyMapping[] allMappings;
        KeyMapping cache = MAPPING_CACHE.get(langKey);
        if (cache != null) {
            return Optional.of(cache);
        }
        for (KeyMapping keyMapping : allMappings = Minecraft.m_91087_().f_91066_.f_92059_) {
            if (!keyMapping.m_90860_().equals(langKey)) continue;
            MAPPING_CACHE.put(langKey, keyMapping);
            return Optional.of(keyMapping);
        }
        return Optional.empty();
    }

    public static Optional<KeyMapping> find(Translation langKey) {
        return KeyboardUtil.find(langKey.langKey());
    }

    public static boolean isMappingConflict(KeyMapping mapping) {
        if (!mapping.m_90862_()) {
            KeyMapping[] allMappings;
            for (KeyMapping keyMapping : allMappings = Minecraft.m_91087_().f_91066_.f_92059_) {
                if (keyMapping == mapping || !mapping.m_90850_(keyMapping)) continue;
                return true;
            }
        }
        return false;
    }
}

