/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.animate;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import mod.adrenix.nostalgic.util.client.animate.Animator;

public interface Animation {
    public static Optional<Animation> find(Object identifier) {
        return Animator.INSTANCES.stream().filter(animation -> animation.getIdentifier().equals(identifier)).findFirst();
    }

    public Animation copy();

    public void setMinValue(double var1);

    public void setMaxValue(double var1);

    public double getValue();

    default public float getFloat() {
        return (float)this.getValue();
    }

    public void tick();

    public void setTickProgress(float var1);

    public double getTickProgress();

    public void reset();

    public void stop();

    public boolean isFinished();

    default public boolean isNotFinished() {
        return !this.isFinished();
    }

    public boolean isMoving();

    public boolean wentForward();

    public boolean wentBackward();

    public void rewind();

    public void play();

    default public void resetAndPlay() {
        this.reset();
        this.play();
    }

    default public void playOrRewind() {
        if (this.isNotFinished()) {
            return;
        }
        if (this.wentBackward()) {
            this.play();
        } else if (this.wentForward()) {
            this.rewind();
        }
    }

    default public void rewindOrPlay() {
        if (this.isNotFinished()) {
            return;
        }
        if (this.wentForward()) {
            this.rewind();
        } else if (this.wentBackward()) {
            this.play();
        }
    }

    public void animateWith(Function<Double, Double> var1);

    public Function<Double, Double> getAnimation();

    public void setDuration(long var1, TimeUnit var3);

    public void setIdentifier(Object var1);

    public Object getIdentifier();
}

