/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.animate;

import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;

public class Animator
implements Animation {
    static final HashSet<Animation> INSTANCES = new HashSet();
    Object identifier;
    private Function<Double, Double> animator = value -> 1.0;
    private double currentValue = 0.0;
    private double lastValue = 0.0;
    private double minValue = Double.MIN_VALUE;
    private double maxValue = Double.MAX_VALUE;
    private double tickProgress = 0.0;
    private double durationInTicks;
    private boolean reverse = false;
    private boolean finished = true;
    private boolean wasForward;
    private boolean wasBackward;

    public static void onTick() {
        INSTANCES.removeIf(Animation::isFinished);
        INSTANCES.forEach(Animation::tick);
    }

    public Animator() {
        this.setDuration(1L, TimeUnit.SECONDS);
    }

    public Animator(Function<Double, Double> animator, long duration, TimeUnit timeUnit) {
        this();
        this.animateWith(animator);
        this.setDuration(duration, timeUnit);
    }

    @Override
    public Animation copy() {
        Animator copy = new Animator();
        copy.animator = this.animator;
        copy.durationInTicks = this.durationInTicks;
        copy.minValue = this.minValue;
        copy.maxValue = this.maxValue;
        return copy;
    }

    @Override
    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    @Override
    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public double getValue() {
        return Mth.m_14139_((double)Minecraft.m_91087_().m_91296_(), (double)this.lastValue, (double)this.currentValue);
    }

    private boolean isReverseFinished() {
        boolean areValuesEqual = this.lastValue == this.currentValue;
        boolean isTickFinished = this.reverse && this.tickProgress <= 0.0 && areValuesEqual;
        boolean isMinReached = this.reverse && this.currentValue <= this.minValue && areValuesEqual;
        return isTickFinished || isMinReached;
    }

    private boolean isForwardFinished() {
        boolean areValuesEqual = this.lastValue == this.currentValue;
        boolean isTickFinished = !this.reverse && this.tickProgress >= this.durationInTicks && areValuesEqual;
        boolean isMaxReached = !this.reverse && this.currentValue >= this.maxValue && areValuesEqual;
        return isTickFinished || isMaxReached;
    }

    @Override
    public void tick() {
        if (this.durationInTicks <= 0.0 || this.isReverseFinished() || this.isForwardFinished()) {
            this.stop();
            return;
        }
        if (this.reverse) {
            this.wasForward = false;
            this.wasBackward = true;
            this.tickProgress -= 1.0;
        } else {
            this.wasForward = true;
            this.wasBackward = false;
            this.tickProgress += 1.0;
        }
        this.tickProgress = Mth.m_14008_((double)this.tickProgress, (double)0.0, (double)this.durationInTicks);
        this.lastValue = this.currentValue;
        this.currentValue = Mth.m_14008_((double)this.animator.apply(this.tickProgress / this.durationInTicks), (double)this.minValue, (double)this.maxValue);
    }

    @Override
    public void setTickProgress(float progress) {
        this.lastValue = 0.0;
        this.tickProgress = (int)Math.round(this.durationInTicks * (double)Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f));
        this.currentValue = Mth.m_14008_((double)this.animator.apply(this.tickProgress / this.durationInTicks), (double)this.minValue, (double)this.maxValue);
    }

    @Override
    public double getTickProgress() {
        return this.tickProgress;
    }

    @Override
    public void reset() {
        this.tickProgress = 0.0;
        this.currentValue = 0.0;
        this.lastValue = 0.0;
        this.reverse = false;
    }

    @Override
    public void stop() {
        if (this.reverse) {
            this.reverse = false;
        }
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isMoving() {
        return this.tickProgress > 0.0 && this.tickProgress < this.durationInTicks;
    }

    @Override
    public boolean wentForward() {
        if (!this.wasForward && !this.wasBackward) {
            return true;
        }
        return this.wasForward;
    }

    @Override
    public boolean wentBackward() {
        if (!this.wasForward && !this.wasBackward) {
            return true;
        }
        return this.wasBackward;
    }

    @Override
    public void rewind() {
        if (this.tickProgress > 0.0) {
            this.reverse = true;
            this.finished = false;
            INSTANCES.add(this);
        }
    }

    @Override
    public void play() {
        this.finished = false;
        INSTANCES.add(this);
        this.reverse = false;
    }

    @Override
    public void animateWith(Function<Double, Double> animator) {
        this.animator = animator;
    }

    @Override
    public Function<Double, Double> getAnimation() {
        return this.animator;
    }

    @Override
    public void setDuration(long duration, TimeUnit timeUnit) {
        this.durationInTicks = (double)timeUnit.toMillis(duration) / 50.0;
    }

    @Override
    public void setIdentifier(Object identifier) {
        this.identifier = identifier;
    }

    @Override
    public Object getIdentifier() {
        return this.identifier;
    }
}

