/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.dialog;

import java.nio.file.Path;
import java.util.Optional;
import mod.adrenix.nostalgic.util.client.dialog.DialogType;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public abstract class FileDialog {
    @Nullable
    public static String getJsonLocation(String windowTitle, @Nullable Path pathAndFile, DialogType dialogType) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer patterns = stack.mallocPointer(1);
            patterns.put(stack.UTF8((CharSequence)"*.json"));
            patterns.flip();
            String desc = "JSON files (*.json)";
            String title = "Nostalgic Tweaks - " + windowTitle;
            String defaultFile = Optional.ofNullable(pathAndFile).map(Path::toString).orElse(null);
            String string = switch (dialogType) {
                default -> throw new IncompatibleClassChangeError();
                case DialogType.OPEN_FILE -> TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)defaultFile, (PointerBuffer)patterns, (CharSequence)desc, (boolean)false);
                case DialogType.SAVE_FILE -> TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)defaultFile, (PointerBuffer)patterns, (CharSequence)desc);
            };
            return string;
        }
    }
}

