/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.gui;

import java.util.Collection;
import java.util.HashSet;
import mod.adrenix.nostalgic.tweak.enums.Corner;
import mod.adrenix.nostalgic.util.client.gui.DrawText;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import mod.adrenix.nostalgic.util.common.data.NumberHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class CornerManager {
    private final float height = GuiUtil.getGuiHeight();
    private final NumberHolder<Double> topLeft = NumberHolder.create(2.0);
    private final NumberHolder<Double> topRight = NumberHolder.create(2.0);
    private final NumberHolder<Double> bottomLeft = NumberHolder.create((double)this.height - 10.0);
    private final NumberHolder<Double> bottomRight = NumberHolder.create((double)this.height - 10.0);

    private double getAndAdd(Corner corner) {
        return switch (corner) {
            default -> throw new IncompatibleClassChangeError();
            case Corner.TOP_LEFT -> this.topLeft.getAndAdd(10.0);
            case Corner.TOP_RIGHT -> this.topRight.getAndAdd(10.0);
            case Corner.BOTTOM_LEFT -> this.bottomLeft.getAndAdd(-10.0);
            case Corner.BOTTOM_RIGHT -> this.bottomRight.getAndAdd(-10.0);
        };
    }

    private int getRightOffset(String text) {
        return GuiUtil.getGuiWidth() - GuiUtil.font().m_92895_(text) - 2;
    }

    public void drawText(GuiGraphics graphics, String text, Corner corner) {
        this.drawText(graphics, text, corner, 0, 0, true);
    }

    public void drawText(GuiGraphics graphics, String text, Corner corner, int xOffset, int yOffset, boolean dropShadow) {
        int x = (corner.isLeft() ? 2 : this.getRightOffset(text)) + xOffset;
        int y = (int)this.getAndAdd(corner) + yOffset;
        if (corner == Corner.TOP_RIGHT) {
            EffectRenderingInventoryScreen screen;
            boolean areEffectsHidden;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Collection effects = NullableResult.getOrElse(player, new HashSet(), LivingEntity::m_21220_);
            Screen screen2 = Minecraft.m_91087_().f_91080_;
            boolean bl = areEffectsHidden = screen2 instanceof EffectRenderingInventoryScreen && (screen = (EffectRenderingInventoryScreen)screen2).m_194018_();
            if (!effects.isEmpty() && !areEffectsHidden) {
                if (effects.stream().anyMatch(MobEffectInstance::m_19575_)) {
                    y += 24;
                }
                if (effects.stream().map(MobEffectInstance::m_19544_).anyMatch(mobEffect -> !mobEffect.m_19486_())) {
                    y += 26;
                }
            }
        }
        x = Mth.m_14045_((int)x, (int)0, (int)(GuiUtil.getGuiWidth() - GuiUtil.font().m_92895_(text)));
        y = Mth.m_14045_((int)y, (int)0, (int)(GuiUtil.getGuiHeight() - GuiUtil.textHeight()));
        DrawText.begin(graphics, text).pos(x, y).setShadow(dropShadow).draw();
    }
}

